/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.autoconfigure;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.autoconfigure.SpanExporterConfiguration;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.autoconfigure.SpiUtil;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.autoconfigure.spi.ConfigurationException;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.autoconfigure.spi.traces.ConfigurableSamplerProvider;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.autoconfigure.spi.traces.SdkTracerProviderConfigurer;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.resources.Resource;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.trace.SdkTracerProvider;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.trace.SdkTracerProviderBuilder;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.trace.SpanLimits;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.trace.SpanLimitsBuilder;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.trace.SpanProcessor;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.trace.export.BatchSpanProcessor;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.trace.export.BatchSpanProcessorBuilder;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.trace.export.SimpleSpanProcessor;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.trace.export.SpanExporter;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.trace.samplers.Sampler;

final class TracerProviderConfiguration {
    static SdkTracerProvider configureTracerProvider(Resource resource, ConfigProperties config) {
        SdkTracerProviderBuilder tracerProviderBuilder = SdkTracerProvider.builder().setResource(resource).setSpanLimits(TracerProviderConfiguration.configureSpanLimits(config));
        String sampler = config.getString("otel.traces.sampler");
        if (sampler != null) {
            tracerProviderBuilder.setSampler(TracerProviderConfiguration.configureSampler(sampler, config));
        }
        for (SdkTracerProviderConfigurer configurer : ServiceLoader.load(SdkTracerProviderConfigurer.class)) {
            configurer.configure(tracerProviderBuilder, config);
        }
        Map<String, SpanExporter> exportersByName = SpanExporterConfiguration.configureSpanExporters(config);
        TracerProviderConfiguration.configureSpanProcessors(config, exportersByName).forEach(tracerProviderBuilder::addSpanProcessor);
        SdkTracerProvider tracerProvider = tracerProviderBuilder.build();
        Runtime.getRuntime().addShutdownHook(new Thread(tracerProvider::close));
        return tracerProvider;
    }

    static List<SpanProcessor> configureSpanProcessors(ConfigProperties config, Map<String, SpanExporter> exportersByName) {
        HashMap<String, SpanExporter> exportersByNameCopy = new HashMap<String, SpanExporter>(exportersByName);
        ArrayList<SpanProcessor> spanProcessors = new ArrayList<SpanProcessor>();
        SpanExporter exporter = exportersByName.get("logging");
        if (exporter != null) {
            spanProcessors.add(SimpleSpanProcessor.create(exporter));
            exportersByNameCopy.remove("logging");
        }
        if (!exportersByNameCopy.isEmpty()) {
            SpanExporter compositeSpanExporter = SpanExporter.composite(exportersByNameCopy.values());
            spanProcessors.add(TracerProviderConfiguration.configureBatchSpanProcessor(config, compositeSpanExporter));
        }
        return spanProcessors;
    }

    static BatchSpanProcessor configureBatchSpanProcessor(ConfigProperties config, SpanExporter exporter) {
        Duration timeout;
        Integer maxExportBatch;
        Integer maxQueue;
        BatchSpanProcessorBuilder builder = BatchSpanProcessor.builder(exporter);
        Duration scheduleDelay = config.getDuration("otel.bsp.schedule.delay");
        if (scheduleDelay != null) {
            builder.setScheduleDelay(scheduleDelay);
        }
        if ((maxQueue = config.getInt("otel.bsp.max.queue.size")) != null) {
            builder.setMaxQueueSize(maxQueue);
        }
        if ((maxExportBatch = config.getInt("otel.bsp.max.export.batch.size")) != null) {
            builder.setMaxExportBatchSize(maxExportBatch);
        }
        if ((timeout = config.getDuration("otel.bsp.export.timeout")) != null) {
            builder.setExporterTimeout(timeout);
        }
        return builder.build();
    }

    static SpanLimits configureSpanLimits(ConfigProperties config) {
        Integer maxLinks;
        Integer maxEvents;
        Integer maxAttrs;
        SpanLimitsBuilder builder = SpanLimits.builder();
        Integer maxLength = config.getInt("otel.span.attribute.value.length.limit");
        if (maxLength != null) {
            builder.setMaxAttributeValueLength(maxLength);
        }
        if ((maxAttrs = config.getInt("otel.span.attribute.count.limit")) != null) {
            builder.setMaxNumberOfAttributes(maxAttrs);
        }
        if ((maxEvents = config.getInt("otel.span.event.count.limit")) != null) {
            builder.setMaxNumberOfEvents(maxEvents);
        }
        if ((maxLinks = config.getInt("otel.span.link.count.limit")) != null) {
            builder.setMaxNumberOfLinks(maxLinks);
        }
        return builder.build();
    }

    static Sampler configureSampler(String sampler, ConfigProperties config) {
        Map<String, Sampler> spiSamplers = SpiUtil.loadConfigurable(ConfigurableSamplerProvider.class, Collections.singletonList(sampler), ConfigurableSamplerProvider::getName, ConfigurableSamplerProvider::createSampler, config);
        switch (sampler) {
            case "always_on": {
                return Sampler.alwaysOn();
            }
            case "always_off": {
                return Sampler.alwaysOff();
            }
            case "traceidratio": {
                Double ratio = config.getDouble("otel.traces.sampler.arg");
                if (ratio == null) {
                    ratio = 1.0;
                }
                return Sampler.traceIdRatioBased(ratio);
            }
            case "parentbased_always_on": {
                return Sampler.parentBased(Sampler.alwaysOn());
            }
            case "parentbased_always_off": {
                return Sampler.parentBased(Sampler.alwaysOff());
            }
            case "parentbased_traceidratio": {
                Double ratio = config.getDouble("otel.traces.sampler.arg");
                if (ratio == null) {
                    ratio = 1.0;
                }
                return Sampler.parentBased(Sampler.traceIdRatioBased(ratio));
            }
        }
        Sampler spiSampler = spiSamplers.get(sampler);
        if (spiSampler == null) {
            throw new ConfigurationException("Unrecognized value for otel.traces.sampler: " + sampler);
        }
        return spiSampler;
    }

    private TracerProviderConfiguration() {
    }
}

