/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.autoconfigure;

import java.time.Duration;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.exporter.jaeger.JaegerGrpcSpanExporter;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.exporter.jaeger.JaegerGrpcSpanExporterBuilder;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.exporter.logging.LoggingSpanExporter;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.exporter.otlp.http.trace.OtlpHttpSpanExporter;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.exporter.otlp.http.trace.OtlpHttpSpanExporterBuilder;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.exporter.otlp.trace.OtlpGrpcSpanExporter;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.exporter.otlp.trace.OtlpGrpcSpanExporterBuilder;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.exporter.zipkin.ZipkinSpanExporter;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.exporter.zipkin.ZipkinSpanExporterBuilder;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.autoconfigure.ClasspathUtil;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.autoconfigure.OtlpConfigUtil;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.autoconfigure.SpiUtil;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.autoconfigure.spi.ConfigurationException;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.autoconfigure.spi.traces.ConfigurableSpanExporterProvider;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.trace.export.SpanExporter;

final class SpanExporterConfiguration {
    private static final String EXPORTER_NONE = "none";

    static Map<String, SpanExporter> configureSpanExporters(ConfigProperties config) {
        List<String> exporterNamesList = config.getList("otel.traces.exporter");
        Set<String> exporterNames = new HashSet<String>(exporterNamesList);
        if (exporterNamesList.size() != exporterNames.size()) {
            String duplicates = exporterNamesList.stream().collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).entrySet().stream().filter(entry -> (Long)entry.getValue() > 1L).map(Map.Entry::getKey).collect(Collectors.joining(",", "[", "]"));
            throw new ConfigurationException("otel.traces.exporter contains duplicates: " + duplicates);
        }
        if (exporterNames.contains(EXPORTER_NONE)) {
            if (exporterNames.size() > 1) {
                throw new ConfigurationException("otel.traces.exporter contains none along with other exporters");
            }
            return Collections.emptyMap();
        }
        if (exporterNames.isEmpty()) {
            exporterNames = Collections.singleton("otlp");
        }
        Map<String, SpanExporter> spiExporters = SpiUtil.loadConfigurable(ConfigurableSpanExporterProvider.class, exporterNamesList, ConfigurableSpanExporterProvider::getName, ConfigurableSpanExporterProvider::createExporter, config);
        return exporterNames.stream().collect(Collectors.toMap(Function.identity(), exporterName -> SpanExporterConfiguration.configureExporter(exporterName, config, spiExporters)));
    }

    static SpanExporter configureExporter(String name, ConfigProperties config, Map<String, SpanExporter> spiExporters) {
        switch (name) {
            case "otlp": {
                return SpanExporterConfiguration.configureOtlp(config);
            }
            case "jaeger": {
                return SpanExporterConfiguration.configureJaeger(config);
            }
            case "zipkin": {
                return SpanExporterConfiguration.configureZipkin(config);
            }
            case "logging": {
                ClasspathUtil.checkClassExists("org.apache.druid.opentelemetry.shaded.io.opentelemetry.exporter.logging.LoggingSpanExporter", "Logging Trace Exporter", "opentelemetry-exporter-logging");
                return new LoggingSpanExporter();
            }
        }
        SpanExporter spiExporter = spiExporters.get(name);
        if (spiExporter == null) {
            throw new ConfigurationException("Unrecognized value for otel.traces.exporter: " + name);
        }
        return spiExporter;
    }

    static SpanExporter configureOtlp(ConfigProperties config) {
        String protocol = OtlpConfigUtil.getOtlpProtocol("traces", config);
        if (protocol.equals("http/protobuf")) {
            ClasspathUtil.checkClassExists("org.apache.druid.opentelemetry.shaded.io.opentelemetry.exporter.otlp.http.trace.OtlpHttpSpanExporter", "OTLP HTTP Trace Exporter", "opentelemetry-exporter-otlp-http-trace");
            OtlpHttpSpanExporterBuilder builder = OtlpHttpSpanExporter.builder();
            OtlpConfigUtil.configureOtlpExporterBuilder("traces", config, arg_0 -> ((OtlpHttpSpanExporterBuilder)builder).setEndpoint(arg_0), (arg_0, arg_1) -> ((OtlpHttpSpanExporterBuilder)builder).addHeader(arg_0, arg_1), arg_0 -> ((OtlpHttpSpanExporterBuilder)builder).setCompression(arg_0), arg_0 -> ((OtlpHttpSpanExporterBuilder)builder).setTimeout(arg_0), arg_0 -> ((OtlpHttpSpanExporterBuilder)builder).setTrustedCertificates(arg_0));
            return builder.build();
        }
        if (protocol.equals("grpc")) {
            ClasspathUtil.checkClassExists("org.apache.druid.opentelemetry.shaded.io.opentelemetry.exporter.otlp.trace.OtlpGrpcSpanExporter", "OTLP gRPC Trace Exporter", "opentelemetry-exporter-otlp");
            OtlpGrpcSpanExporterBuilder builder = OtlpGrpcSpanExporter.builder();
            OtlpConfigUtil.configureOtlpExporterBuilder("traces", config, arg_0 -> ((OtlpGrpcSpanExporterBuilder)builder).setEndpoint(arg_0), (arg_0, arg_1) -> ((OtlpGrpcSpanExporterBuilder)builder).addHeader(arg_0, arg_1), arg_0 -> ((OtlpGrpcSpanExporterBuilder)builder).setCompression(arg_0), arg_0 -> ((OtlpGrpcSpanExporterBuilder)builder).setTimeout(arg_0), arg_0 -> ((OtlpGrpcSpanExporterBuilder)builder).setTrustedCertificates(arg_0));
            return builder.build();
        }
        throw new ConfigurationException("Unsupported OTLP traces protocol: " + protocol);
    }

    private static SpanExporter configureJaeger(ConfigProperties config) {
        Duration timeout;
        ClasspathUtil.checkClassExists("org.apache.druid.opentelemetry.shaded.io.opentelemetry.exporter.jaeger.JaegerGrpcSpanExporter", "Jaeger gRPC Exporter", "opentelemetry-exporter-jaeger");
        JaegerGrpcSpanExporterBuilder builder = JaegerGrpcSpanExporter.builder();
        String endpoint = config.getString("otel.exporter.jaeger.endpoint");
        if (endpoint != null) {
            builder.setEndpoint(endpoint);
        }
        if ((timeout = config.getDuration("otel.exporter.jaeger.timeout")) != null) {
            builder.setTimeout(timeout);
        }
        return builder.build();
    }

    private static SpanExporter configureZipkin(ConfigProperties config) {
        Duration timeout;
        ClasspathUtil.checkClassExists("org.apache.druid.opentelemetry.shaded.io.opentelemetry.exporter.zipkin.ZipkinSpanExporter", "Zipkin Exporter", "opentelemetry-exporter-zipkin");
        ZipkinSpanExporterBuilder builder = ZipkinSpanExporter.builder();
        String endpoint = config.getString("otel.exporter.zipkin.endpoint");
        if (endpoint != null) {
            builder.setEndpoint(endpoint);
        }
        if ((timeout = config.getDuration("otel.exporter.zipkin.timeout")) != null) {
            builder.setReadTimeout(timeout);
        }
        return builder.build();
    }

    private SpanExporterConfiguration() {
    }
}

