/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.autoconfigure;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.api.baggage.propagation.W3CBaggagePropagator;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.api.trace.propagation.W3CTraceContextPropagator;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.context.propagation.ContextPropagators;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.context.propagation.TextMapPropagator;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.autoconfigure.SpiUtil;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.autoconfigure.spi.ConfigurablePropagatorProvider;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.autoconfigure.spi.ConfigurationException;

final class PropagatorConfiguration {
    static ContextPropagators configurePropagators(ConfigProperties config) {
        LinkedHashSet<TextMapPropagator> propagators = new LinkedHashSet<TextMapPropagator>();
        List<String> requestedPropagators = config.getList("otel.propagators");
        if (requestedPropagators.isEmpty()) {
            requestedPropagators = Arrays.asList("tracecontext", "baggage");
        }
        Map<String, TextMapPropagator> spiPropagators = SpiUtil.loadConfigurable(ConfigurablePropagatorProvider.class, requestedPropagators, ConfigurablePropagatorProvider::getName, ConfigurablePropagatorProvider::getPropagator, config);
        for (String propagatorName : requestedPropagators) {
            propagators.add(PropagatorConfiguration.getPropagator(propagatorName, spiPropagators));
        }
        return ContextPropagators.create(TextMapPropagator.composite(propagators));
    }

    private static TextMapPropagator getPropagator(String name, Map<String, TextMapPropagator> spiPropagators) {
        if (name.equals("tracecontext")) {
            return W3CTraceContextPropagator.getInstance();
        }
        if (name.equals("baggage")) {
            return W3CBaggagePropagator.getInstance();
        }
        TextMapPropagator spiPropagator = spiPropagators.get(name);
        if (spiPropagator != null) {
            return spiPropagator;
        }
        throw new ConfigurationException("Unrecognized value for otel.propagators: " + name + ". Make sure the artifact including the propagator is on the classpath.");
    }

    private PropagatorConfiguration() {
    }
}

