/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.autoconfigure;

import java.util.HashSet;
import java.util.ServiceLoader;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.autoconfigure.DefaultConfigProperties;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.autoconfigure.EnvironmentResource;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.autoconfigure.spi.ResourceProvider;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.resources.Resource;

public final class OpenTelemetryResourceAutoConfiguration {
    public static Resource configureResource() {
        return OpenTelemetryResourceAutoConfiguration.configureResource(DefaultConfigProperties.get());
    }

    public static Resource configureResource(ConfigProperties config) {
        Resource result = Resource.getDefault();
        HashSet<String> disabledProviders = new HashSet<String>(config.getList("otel.java.disabled.resource.providers"));
        for (ResourceProvider resourceProvider : ServiceLoader.load(ResourceProvider.class)) {
            if (disabledProviders.contains(resourceProvider.getClass().getName())) continue;
            result = result.merge(resourceProvider.createResource(config));
        }
        result = result.merge(EnvironmentResource.create(config));
        return result;
    }

    private OpenTelemetryResourceAutoConfiguration() {
    }
}

