/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.autoconfigure;

import io.prometheus.client.exporter.HTTPServer;
import java.io.IOException;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.exporter.logging.LoggingMetricExporter;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.exporter.otlp.http.metrics.OtlpHttpMetricExporter;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.exporter.otlp.http.metrics.OtlpHttpMetricExporterBuilder;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.exporter.otlp.metrics.OtlpGrpcMetricExporter;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.exporter.otlp.metrics.OtlpGrpcMetricExporterBuilder;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.exporter.prometheus.PrometheusCollector;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.autoconfigure.ClasspathUtil;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.autoconfigure.OtlpConfigUtil;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.autoconfigure.SpiUtil;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.autoconfigure.spi.ConfigurationException;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.autoconfigure.spi.metrics.ConfigurableMetricExporterProvider;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.SdkMeterProviderBuilder;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.export.MetricExporter;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.export.PeriodicMetricReader;

final class MetricExporterConfiguration {
    static void configureExporter(String name, ConfigProperties config, SdkMeterProviderBuilder sdkMeterProviderBuilder) {
        switch (name) {
            case "otlp": {
                MetricExporterConfiguration.configureOtlpMetrics(config, sdkMeterProviderBuilder);
                return;
            }
            case "prometheus": {
                MetricExporterConfiguration.configurePrometheusMetrics(config, sdkMeterProviderBuilder);
                return;
            }
            case "logging": {
                ClasspathUtil.checkClassExists("org.apache.druid.opentelemetry.shaded.io.opentelemetry.exporter.logging.LoggingMetricExporter", "Logging Metrics Exporter", "opentelemetry-exporter-logging");
                MetricExporterConfiguration.configureLoggingMetrics(config, sdkMeterProviderBuilder);
                return;
            }
            case "none": {
                return;
            }
        }
        MetricExporter spiExporter = MetricExporterConfiguration.configureSpiExporter(name, config);
        if (spiExporter == null) {
            throw new ConfigurationException("Unrecognized value for otel.metrics.exporter: " + name);
        }
        MetricExporterConfiguration.configurePeriodicMetricReader(config, sdkMeterProviderBuilder, spiExporter);
    }

    @Nullable
    static MetricExporter configureSpiExporter(String name, ConfigProperties config) {
        Map<String, MetricExporter> spiExporters = SpiUtil.loadConfigurable(ConfigurableMetricExporterProvider.class, Collections.singletonList(name), ConfigurableMetricExporterProvider::getName, ConfigurableMetricExporterProvider::createExporter, config);
        return spiExporters.get(name);
    }

    private static void configureLoggingMetrics(ConfigProperties config, SdkMeterProviderBuilder sdkMeterProviderBuilder) {
        MetricExporterConfiguration.configurePeriodicMetricReader(config, sdkMeterProviderBuilder, (MetricExporter)new LoggingMetricExporter());
    }

    @Nullable
    static MetricExporter configureOtlpMetrics(ConfigProperties config, SdkMeterProviderBuilder sdkMeterProviderBuilder) {
        OtlpHttpMetricExporter exporter;
        String protocol = OtlpConfigUtil.getOtlpProtocol("metrics", config);
        if (protocol.equals("http/protobuf")) {
            try {
                ClasspathUtil.checkClassExists("org.apache.druid.opentelemetry.shaded.io.opentelemetry.exporter.otlp.http.metrics.OtlpHttpMetricExporter", "OTLP HTTP Metrics Exporter", "opentelemetry-exporter-otlp-http-metrics");
            }
            catch (ConfigurationException e) {
                return null;
            }
            OtlpHttpMetricExporterBuilder builder = OtlpHttpMetricExporter.builder();
            OtlpConfigUtil.configureOtlpExporterBuilder("metrics", config, arg_0 -> ((OtlpHttpMetricExporterBuilder)builder).setEndpoint(arg_0), (arg_0, arg_1) -> ((OtlpHttpMetricExporterBuilder)builder).addHeader(arg_0, arg_1), arg_0 -> ((OtlpHttpMetricExporterBuilder)builder).setCompression(arg_0), arg_0 -> ((OtlpHttpMetricExporterBuilder)builder).setTimeout(arg_0), arg_0 -> ((OtlpHttpMetricExporterBuilder)builder).setTrustedCertificates(arg_0));
            exporter = builder.build();
        } else if (protocol.equals("grpc")) {
            try {
                ClasspathUtil.checkClassExists("org.apache.druid.opentelemetry.shaded.io.opentelemetry.exporter.otlp.metrics.OtlpGrpcMetricExporter", "OTLP gRPC Metrics Exporter", "opentelemetry-exporter-otlp-metrics");
            }
            catch (ConfigurationException e) {
                return null;
            }
            OtlpGrpcMetricExporterBuilder builder = OtlpGrpcMetricExporter.builder();
            OtlpConfigUtil.configureOtlpExporterBuilder("metrics", config, arg_0 -> ((OtlpGrpcMetricExporterBuilder)builder).setEndpoint(arg_0), (arg_0, arg_1) -> ((OtlpGrpcMetricExporterBuilder)builder).addHeader(arg_0, arg_1), arg_0 -> ((OtlpGrpcMetricExporterBuilder)builder).setCompression(arg_0), arg_0 -> ((OtlpGrpcMetricExporterBuilder)builder).setTimeout(arg_0), arg_0 -> ((OtlpGrpcMetricExporterBuilder)builder).setTrustedCertificates(arg_0));
            exporter = builder.build();
        } else {
            throw new ConfigurationException("Unsupported OTLP metrics protocol: " + protocol);
        }
        MetricExporterConfiguration.configurePeriodicMetricReader(config, sdkMeterProviderBuilder, (MetricExporter)exporter);
        return exporter;
    }

    private static void configurePeriodicMetricReader(ConfigProperties config, SdkMeterProviderBuilder sdkMeterProviderBuilder, MetricExporter exporter) {
        Duration exportInterval = config.getDuration("otel.imr.export.interval");
        if (exportInterval == null) {
            exportInterval = Duration.ofMinutes(1L);
        }
        sdkMeterProviderBuilder.registerMetricReader(PeriodicMetricReader.create(exporter, exportInterval));
    }

    private static void configurePrometheusMetrics(ConfigProperties config, SdkMeterProviderBuilder sdkMeterProviderBuilder) {
        HTTPServer server;
        String host;
        ClasspathUtil.checkClassExists("org.apache.druid.opentelemetry.shaded.io.opentelemetry.exporter.prometheus.PrometheusCollector", "Prometheus Metrics Server", "opentelemetry-exporter-prometheus");
        sdkMeterProviderBuilder.registerMetricReader(PrometheusCollector.create());
        Integer port = config.getInt("otel.exporter.prometheus.port");
        if (port == null) {
            port = 9464;
        }
        if ((host = config.getString("otel.exporter.prometheus.host")) == null) {
            host = "0.0.0.0";
        }
        try {
            server = new HTTPServer(host, port.intValue(), true);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to create Prometheus server", e);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(() -> ((HTTPServer)server).close()));
    }

    private MetricExporterConfiguration() {
    }
}

