/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.autoconfigure;

import org.apache.druid.opentelemetry.shaded.io.opentelemetry.api.common.Attributes;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.api.common.AttributesBuilder;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.autoconfigure.DefaultConfigProperties;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.resources.Resource;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.semconv.resource.attributes.ResourceAttributes;

public final class EnvironmentResource {
    static final String ATTRIBUTE_PROPERTY = "otel.resource.attributes";
    static final String SERVICE_NAME_PROPERTY = "otel.service.name";

    public static Resource get() {
        return EnvironmentResource.create(DefaultConfigProperties.get());
    }

    static Resource create(ConfigProperties config) {
        return Resource.create(EnvironmentResource.getAttributes(config), "https://opentelemetry.io/schemas/1.7.0");
    }

    static Attributes getAttributes(ConfigProperties configProperties) {
        AttributesBuilder resourceAttributes = Attributes.builder();
        configProperties.getMap(ATTRIBUTE_PROPERTY).forEach(resourceAttributes::put);
        String serviceName = configProperties.getString(SERVICE_NAME_PROPERTY);
        if (serviceName != null) {
            resourceAttributes.put(ResourceAttributes.SERVICE_NAME, serviceName);
        }
        return resourceAttributes.build();
    }

    private EnvironmentResource() {
    }
}

