/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.opentelemetry.shaded.io.opentelemetry.api.internal;

import com.google.auto.value.AutoValue;
import javax.annotation.concurrent.Immutable;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.api.internal.AutoValue_ImmutableSpanContext;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.api.trace.SpanContext;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.api.trace.SpanId;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.api.trace.TraceFlags;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.api.trace.TraceId;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.api.trace.TraceState;

@Immutable
@AutoValue
public abstract class ImmutableSpanContext
implements SpanContext {
    public static final SpanContext INVALID = ImmutableSpanContext.createInternal(TraceId.getInvalid(), SpanId.getInvalid(), TraceFlags.getDefault(), TraceState.getDefault(), false, false);

    private static AutoValue_ImmutableSpanContext createInternal(String traceId, String spanId, TraceFlags traceFlags, TraceState traceState, boolean remote, boolean valid) {
        return new AutoValue_ImmutableSpanContext(traceId, spanId, traceFlags, traceState, remote, valid);
    }

    public static SpanContext create(String traceIdHex, String spanIdHex, TraceFlags traceFlags, TraceState traceState, boolean remote, boolean skipIdValidation) {
        if (skipIdValidation || SpanId.isValid(spanIdHex) && TraceId.isValid(traceIdHex)) {
            return ImmutableSpanContext.createInternal(traceIdHex, spanIdHex, traceFlags, traceState, remote, true);
        }
        return ImmutableSpanContext.createInternal(TraceId.getInvalid(), SpanId.getInvalid(), traceFlags, traceState, remote, false);
    }

    @Override
    public abstract boolean isValid();
}

