/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.emitter.opentelemetry;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.druid.emitter.opentelemetry.DruidContextTextMapGetter;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.emitter.core.Emitter;
import org.apache.druid.java.util.emitter.core.Event;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.api.OpenTelemetry;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.api.trace.Span;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.api.trace.StatusCode;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.api.trace.Tracer;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.context.Context;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.context.Scope;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.context.propagation.TextMapPropagator;
import org.joda.time.DateTime;

public class OpenTelemetryEmitter
implements Emitter {
    static final DruidContextTextMapGetter DRUID_CONTEXT_TEXT_MAP_GETTER = new DruidContextTextMapGetter();
    static final HashSet<String> TRACEPARENT_PROPAGATION_FIELDS = new HashSet<String>(Arrays.asList("traceparent", "tracestate"));
    private static final Logger log = new Logger(OpenTelemetryEmitter.class);
    private final Tracer tracer;
    private final TextMapPropagator propagator;

    OpenTelemetryEmitter(OpenTelemetry openTelemetry) {
        this.tracer = openTelemetry.getTracer("druid-opentelemetry-extension");
        this.propagator = openTelemetry.getPropagators().getTextMapPropagator();
    }

    public void start() {
        log.debug("Starting OpenTelemetryEmitter", new Object[0]);
    }

    public void emit(Event e) {
        if (!(e instanceof ServiceMetricEvent)) {
            return;
        }
        ServiceMetricEvent event = (ServiceMetricEvent)e;
        if (!event.getMetric().equals("query/time")) {
            return;
        }
        this.emitQueryTimeEvent(event);
    }

    private void emitQueryTimeEvent(ServiceMetricEvent event) {
        Context opentelemetryContext = this.propagator.extract(Context.current(), event, DRUID_CONTEXT_TEXT_MAP_GETTER);
        try (Scope scope = opentelemetryContext.makeCurrent();){
            DateTime endTime = event.getCreatedTime();
            DateTime startTime = endTime.minusMillis(event.getValue().intValue());
            Span span = this.tracer.spanBuilder(event.getService()).setStartTimestamp(startTime.getMillis(), TimeUnit.MILLISECONDS).startSpan();
            OpenTelemetryEmitter.getContext(event).entrySet().stream().filter(entry -> entry.getValue() != null).filter(entry -> !TRACEPARENT_PROPAGATION_FIELDS.contains(entry.getKey())).forEach(entry -> span.setAttribute((String)entry.getKey(), entry.getValue().toString()));
            Object status = event.getUserDims().get("success");
            if (status == null) {
                span.setStatus(StatusCode.UNSET);
            } else if (status.toString().equals("true")) {
                span.setStatus(StatusCode.OK);
            } else {
                span.setStatus(StatusCode.ERROR);
            }
            span.end(endTime.getMillis(), TimeUnit.MILLISECONDS);
        }
    }

    private static Map<String, Object> getContext(ServiceMetricEvent event) {
        Object context = event.getUserDims().get("context");
        if (context instanceof Map) {
            return (Map)context;
        }
        return Collections.emptyMap();
    }

    public void flush() {
    }

    public void close() {
    }
}

