/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.emitter.opentelemetry;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.context.propagation.TextMapGetter;

public class DruidContextTextMapGetter
implements TextMapGetter<ServiceMetricEvent> {
    private Map<String, Object> getContext(ServiceMetricEvent event) {
        Object context = event.getUserDims().get("context");
        if (context instanceof Map) {
            return (Map)context;
        }
        return Collections.emptyMap();
    }

    @Override
    @Nullable
    public String get(ServiceMetricEvent event, String key) {
        return Optional.ofNullable(this.getContext(event).get(key)).map(Objects::toString).orElse(null);
    }

    @Override
    public Iterable<String> keys(ServiceMetricEvent event) {
        return this.getContext(event).keySet();
    }
}

