/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import io.grpc.internal.ClientStream;
import io.grpc.internal.ClientStreamListener;
import io.grpc.internal.ClientTransport;
import io.grpc.internal.FailingClientStream;
import java.util.concurrent.Executor;
import org.apache.druid.opentelemetry.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.druid.opentelemetry.shaded.com.google.common.base.Preconditions;
import org.apache.druid.opentelemetry.shaded.com.google.common.util.concurrent.ListenableFuture;
import org.apache.druid.opentelemetry.shaded.com.google.common.util.concurrent.SettableFuture;
import org.apache.druid.opentelemetry.shaded.io.grpc.CallOptions;
import org.apache.druid.opentelemetry.shaded.io.grpc.ClientStreamTracer;
import org.apache.druid.opentelemetry.shaded.io.grpc.InternalChannelz;
import org.apache.druid.opentelemetry.shaded.io.grpc.InternalLogId;
import org.apache.druid.opentelemetry.shaded.io.grpc.Metadata;
import org.apache.druid.opentelemetry.shaded.io.grpc.MethodDescriptor;
import org.apache.druid.opentelemetry.shaded.io.grpc.Status;

class FailingClientTransport
implements ClientTransport {
    @VisibleForTesting
    final Status error;
    private final ClientStreamListener.RpcProgress rpcProgress;

    FailingClientTransport(Status error, ClientStreamListener.RpcProgress rpcProgress) {
        Preconditions.checkArgument(!error.isOk(), "error must not be OK");
        this.error = error;
        this.rpcProgress = rpcProgress;
    }

    @Override
    public ClientStream newStream(MethodDescriptor<?, ?> method, Metadata headers, CallOptions callOptions, ClientStreamTracer[] tracers) {
        return new FailingClientStream(this.error, this.rpcProgress, tracers);
    }

    @Override
    public void ping(final ClientTransport.PingCallback callback, Executor executor) {
        executor.execute(new Runnable(){

            @Override
            public void run() {
                callback.onFailure(FailingClientTransport.this.error.asException());
            }
        });
    }

    @Override
    public ListenableFuture<InternalChannelz.SocketStats> getStats() {
        SettableFuture<InternalChannelz.SocketStats> ret = SettableFuture.create();
        ret.set(null);
        return ret;
    }

    @Override
    public InternalLogId getLogId() {
        throw new UnsupportedOperationException("Not a real transport");
    }
}

