/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.materializedview;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import org.apache.druid.java.util.common.guava.MergeSequence;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.context.ResponseContext;
import org.apache.druid.query.materializedview.DataSourceOptimizer;

public class MaterializedViewQueryRunner<T>
implements QueryRunner<T> {
    private final QueryRunner runner;
    private final DataSourceOptimizer optimizer;

    public MaterializedViewQueryRunner(QueryRunner queryRunner, DataSourceOptimizer optimizer) {
        this.runner = queryRunner;
        this.optimizer = optimizer;
    }

    public Sequence<T> run(final QueryPlus<T> queryPlus, final ResponseContext responseContext) {
        Query query = queryPlus.getQuery();
        return new MergeSequence(query.getResultOrdering(), Sequences.simple((Iterable)Lists.transform(this.optimizer.optimize(query), (Function)new Function<Query, Sequence<T>>(){

            public Sequence<T> apply(Query query) {
                return MaterializedViewQueryRunner.this.runner.run(queryPlus.withQuery(query), responseContext);
            }
        })));
    }
}

