/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.materializedview;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.inject.Inject;
import java.util.Comparator;
import java.util.function.BinaryOperator;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryMetrics;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryToolChest;
import org.apache.druid.query.QueryToolChestWarehouse;
import org.apache.druid.query.aggregation.MetricManipulationFn;
import org.apache.druid.query.context.ResponseContext;
import org.apache.druid.query.materializedview.DataSourceOptimizer;
import org.apache.druid.query.materializedview.MaterializedViewQuery;
import org.apache.druid.query.materializedview.MaterializedViewQueryRunner;

public class MaterializedViewQueryQueryToolChest
extends QueryToolChest {
    private final QueryToolChestWarehouse warehouse;
    private DataSourceOptimizer optimizer;

    @Inject
    public MaterializedViewQueryQueryToolChest(QueryToolChestWarehouse warehouse) {
        this.warehouse = warehouse;
    }

    public QueryRunner mergeResults(final QueryRunner runner) {
        return new QueryRunner(){

            public Sequence run(QueryPlus queryPlus, ResponseContext responseContext) {
                Query realQuery = MaterializedViewQueryQueryToolChest.this.getRealQuery(queryPlus.getQuery());
                return MaterializedViewQueryQueryToolChest.this.warehouse.getToolChest(realQuery).mergeResults(runner).run(queryPlus.withQuery(realQuery), responseContext);
            }
        };
    }

    public QueryRunner mergeResults(final QueryRunner runner, final boolean willMergeRunner) {
        return new QueryRunner(){

            public Sequence run(QueryPlus queryPlus, ResponseContext responseContext) {
                Query realQuery = MaterializedViewQueryQueryToolChest.this.getRealQuery(queryPlus.getQuery());
                return MaterializedViewQueryQueryToolChest.this.warehouse.getToolChest(realQuery).mergeResults(runner, willMergeRunner).run(queryPlus.withQuery(realQuery), responseContext);
            }
        };
    }

    public BinaryOperator createMergeFn(Query query) {
        Query realQuery = this.getRealQuery(query);
        return this.warehouse.getToolChest(realQuery).createMergeFn(realQuery);
    }

    public Comparator createResultComparator(Query query) {
        Query realQuery = this.getRealQuery(query);
        return this.warehouse.getToolChest(realQuery).createResultComparator(realQuery);
    }

    public QueryMetrics makeMetrics(Query query) {
        Query realQuery = this.getRealQuery(query);
        return this.warehouse.getToolChest(realQuery).makeMetrics(realQuery);
    }

    public Function makePreComputeManipulatorFn(Query query, MetricManipulationFn fn) {
        Query realQuery = this.getRealQuery(query);
        return this.warehouse.getToolChest(realQuery).makePreComputeManipulatorFn(realQuery, fn);
    }

    public Function makePostComputeManipulatorFn(Query query, MetricManipulationFn fn) {
        Query realQuery = this.getRealQuery(query);
        return this.warehouse.getToolChest(realQuery).makePostComputeManipulatorFn(realQuery, fn);
    }

    public ObjectMapper decorateObjectMapper(ObjectMapper objectMapper, Query query) {
        Query realQuery = this.getRealQuery(query);
        return this.warehouse.getToolChest(realQuery).decorateObjectMapper(objectMapper, realQuery);
    }

    public TypeReference getResultTypeReference() {
        return null;
    }

    public QueryRunner preMergeQueryDecoration(final QueryRunner runner) {
        return new QueryRunner(){

            public Sequence run(QueryPlus queryPlus, ResponseContext responseContext) {
                Query realQuery = MaterializedViewQueryQueryToolChest.this.getRealQuery(queryPlus.getQuery());
                QueryToolChest realQueryToolChest = MaterializedViewQueryQueryToolChest.this.warehouse.getToolChest(realQuery);
                QueryRunner realQueryRunner = realQueryToolChest.preMergeQueryDecoration(new MaterializedViewQueryRunner(runner, MaterializedViewQueryQueryToolChest.this.optimizer));
                return realQueryRunner.run(queryPlus.withQuery(realQuery), responseContext);
            }
        };
    }

    public Query getRealQuery(Query query) {
        if (query instanceof MaterializedViewQuery) {
            this.optimizer = ((MaterializedViewQuery)query).getOptimizer();
            return ((MaterializedViewQuery)query).getQuery();
        }
        return query;
    }
}

