/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.grpc.server;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import javax.inject.Inject;
import org.apache.druid.grpc.server.GrpcQueryConfig;
import org.apache.druid.grpc.server.QueryDriver;
import org.apache.druid.grpc.server.QueryServer;
import org.apache.druid.guice.ManageLifecycleServer;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.guice.annotations.NativeQuery;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.lifecycle.LifecycleStart;
import org.apache.druid.java.util.common.lifecycle.LifecycleStop;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.DefaultQueryConfig;
import org.apache.druid.server.QueryLifecycleFactory;
import org.apache.druid.server.security.AuthenticatorMapper;
import org.apache.druid.sql.SqlStatementFactory;

@ManageLifecycleServer
public class GrpcEndpointInitializer {
    private static final Logger log = new Logger(GrpcEndpointInitializer.class);
    private final GrpcQueryConfig config;
    private final QueryDriver driver;
    private final AuthenticatorMapper authMapper;
    private QueryServer server;

    @Inject
    public GrpcEndpointInitializer(GrpcQueryConfig config, @Json ObjectMapper jsonMapper, @NativeQuery SqlStatementFactory sqlStatementFactory, QueryLifecycleFactory queryLifecycleFactory, DefaultQueryConfig defaultQueryConfig, AuthenticatorMapper authMapper) {
        this.config = config;
        this.authMapper = authMapper;
        this.driver = new QueryDriver(jsonMapper, sqlStatementFactory, defaultQueryConfig.getContext(), queryLifecycleFactory);
    }

    @LifecycleStart
    public void start() {
        this.server = new QueryServer(this.config, this.driver, this.authMapper);
        try {
            this.server.start();
        }
        catch (IOException e) {
            log.error((Throwable)e, "Fatal error: gRPC query server startup failed", new Object[0]);
            throw new ISE((Throwable)e, "Fatal error: grpc query server startup failed", new Object[0]);
        }
        catch (Throwable t) {
            log.error(t, "Fatal error: gRPC query server startup failed", new Object[0]);
            throw t;
        }
    }

    @LifecycleStop
    public void stop() {
        if (this.server != null) {
            try {
                this.server.blockUntilShutdown();
            }
            catch (InterruptedException e) {
                log.warn((Throwable)e, "gRPC query server shutdown failed", new Object[0]);
            }
            this.server = null;
        }
    }
}

