/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.grpc.server;

import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import org.apache.druid.grpc.proto.QueryGrpc;
import org.apache.druid.grpc.proto.QueryOuterClass;
import org.apache.druid.grpc.server.QueryDriver;
import org.apache.druid.grpc.server.QueryServer;
import org.apache.druid.server.security.AuthenticationResult;
import org.apache.druid.server.security.ForbiddenException;

class QueryService
extends QueryGrpc.QueryImplBase {
    private final QueryDriver driver;

    public QueryService(QueryDriver driver) {
        this.driver = driver;
    }

    @Override
    public void submitQuery(QueryOuterClass.QueryRequest request, StreamObserver<QueryOuterClass.QueryResponse> responseObserver) {
        try {
            QueryOuterClass.QueryResponse reply = this.driver.submitQuery(request, (AuthenticationResult)QueryServer.AUTH_KEY.get());
            responseObserver.onNext((Object)reply);
            responseObserver.onCompleted();
        }
        catch (ForbiddenException e) {
            responseObserver.onError((Throwable)new StatusRuntimeException(Status.PERMISSION_DENIED));
        }
    }
}

