/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.grpc.server;

import com.google.protobuf.ByteString;
import com.google.protobuf.Timestamp;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.List;
import java.util.Optional;
import java.util.TimeZone;
import javax.annotation.Nullable;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.sql.SqlRowTransformer;
import org.apache.druid.sql.calcite.planner.Calcites;
import org.apache.druid.sql.calcite.table.RowSignatures;
import org.joda.time.DateTime;
import org.joda.time.DateTimeUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;

public class ProtobufTransformer {
    @Nullable
    public static Object transform(SqlRowTransformer rowTransformer, Object[] row, int i) {
        if (row[i] == null) {
            return null;
        }
        RelDataType rowType = rowTransformer.getRowType();
        SqlTypeName sqlTypeName = ((RelDataTypeField)rowType.getFieldList().get(i)).getType().getSqlTypeName();
        RowSignature signature = RowSignatures.fromRelDataType((List)rowType.getFieldNames(), (RelDataType)rowType);
        Optional columnType = signature.getColumnType(i);
        if (sqlTypeName == SqlTypeName.TIMESTAMP || sqlTypeName == SqlTypeName.DATE) {
            if (sqlTypeName == SqlTypeName.TIMESTAMP) {
                return ProtobufTransformer.convertEpochToProtoTimestamp((Long)row[i]);
            }
            return ProtobufTransformer.convertDateToProtoTimestamp((Integer)row[i]);
        }
        if (!columnType.isPresent()) {
            return ProtobufTransformer.convertComplexType(row[i]);
        }
        ColumnType druidType = (ColumnType)columnType.get();
        if (druidType == ColumnType.STRING) {
            return row[i];
        }
        if (druidType == ColumnType.LONG) {
            return row[i];
        }
        if (druidType == ColumnType.FLOAT) {
            return row[i];
        }
        if (druidType == ColumnType.DOUBLE) {
            return row[i];
        }
        return ProtobufTransformer.convertComplexType(row[i]);
    }

    @Nullable
    public static Object transform(RowSignature rowSignature, Object[] row, int i, boolean convertToTimestamp) {
        if (row[i] == null) {
            return null;
        }
        Optional columnType = rowSignature.getColumnType(i);
        if (convertToTimestamp) {
            return ProtobufTransformer.convertEpochToProtoTimestamp((Long)row[i]);
        }
        if (!columnType.isPresent()) {
            return ProtobufTransformer.convertComplexType(row[i]);
        }
        ColumnType druidType = (ColumnType)columnType.get();
        if (druidType == ColumnType.STRING) {
            return row[i];
        }
        if (druidType == ColumnType.LONG) {
            return row[i];
        }
        if (druidType == ColumnType.FLOAT) {
            return row[i];
        }
        if (druidType == ColumnType.DOUBLE) {
            return row[i];
        }
        return ProtobufTransformer.convertComplexType(row[i]);
    }

    public static Timestamp convertEpochToProtoTimestamp(long value) {
        DateTime dateTime = Calcites.calciteTimestampToJoda((long)value, (DateTimeZone)DateTimeZone.forTimeZone((TimeZone)TimeZone.getTimeZone("UTC")));
        long seconds = DateTimeUtils.getInstantMillis((ReadableInstant)dateTime) / 1000L;
        return Timestamp.newBuilder().setSeconds(seconds).build();
    }

    public static Timestamp convertDateToProtoTimestamp(int value) {
        DateTime dateTime = Calcites.calciteDateToJoda((int)value, (DateTimeZone)DateTimeZone.forTimeZone((TimeZone)TimeZone.getTimeZone("UTC")));
        long seconds = DateTimeUtils.getInstantMillis((ReadableInstant)dateTime) / 1000L;
        return Timestamp.newBuilder().setSeconds(seconds).build();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static ByteString convertComplexType(Object value) {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            ByteString byteString;
            try (ObjectOutputStream oos = new ObjectOutputStream(bos);){
                oos.writeObject(value);
                oos.flush();
                byteString = ByteString.copyFrom((byte[])bos.toByteArray());
            }
            return byteString;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

