/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.grpc.server;

import io.grpc.BindableService;
import io.grpc.Context;
import io.grpc.Grpc;
import io.grpc.InsecureServerCredentials;
import io.grpc.Server;
import io.grpc.ServerCredentials;
import io.grpc.ServerInterceptor;
import io.grpc.ServerInterceptors;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.druid.grpc.proto.HealthOuterClass;
import org.apache.druid.grpc.server.AnonymousAuthServerInterceptor;
import org.apache.druid.grpc.server.BasicAuthServerInterceptor;
import org.apache.druid.grpc.server.GrpcQueryConfig;
import org.apache.druid.grpc.server.HealthService;
import org.apache.druid.grpc.server.QueryDriver;
import org.apache.druid.grpc.server.QueryService;
import org.apache.druid.java.util.common.UOE;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.server.security.AllowAllAuthenticator;
import org.apache.druid.server.security.AnonymousAuthenticator;
import org.apache.druid.server.security.AuthenticationResult;
import org.apache.druid.server.security.Authenticator;
import org.apache.druid.server.security.AuthenticatorMapper;

public class QueryServer {
    public static final Context.Key<AuthenticationResult> AUTH_KEY = Context.key((String)"druid-auth");
    private static final Logger log = new Logger(QueryServer.class);
    private final AuthenticatorMapper authMapper;
    private final int port;
    private final QueryDriver driver;
    private Server server;
    private final HealthService healthService;

    public QueryServer(GrpcQueryConfig config, QueryDriver driver, AuthenticatorMapper authMapper) {
        this.port = config.getPort();
        this.driver = driver;
        this.authMapper = authMapper;
        this.healthService = new HealthService();
    }

    public void start() throws IOException {
        this.server = Grpc.newServerBuilderForPort((int)this.port, (ServerCredentials)InsecureServerCredentials.create()).addService(ServerInterceptors.intercept((BindableService)new QueryService(this.driver), (ServerInterceptor[])new ServerInterceptor[]{this.makeSecurityInterceptor()})).addService((BindableService)this.healthService).build().start();
        this.healthService.registerService(QueryService.class.getSimpleName(), HealthOuterClass.HealthCheckResponse.ServingStatus.SERVING);
        this.healthService.registerService("", HealthOuterClass.HealthCheckResponse.ServingStatus.SERVING);
        log.info("Grpc Server started, listening on " + this.port, new Object[0]);
    }

    private ServerInterceptor makeSecurityInterceptor() {
        for (Authenticator authenticator : this.authMapper.getAuthenticatorChain()) {
            if (!"BasicHTTPAuthenticator".equals(authenticator.getClass().getSimpleName())) continue;
            log.info("Using Basic authentication", new Object[0]);
            return new BasicAuthServerInterceptor(authenticator);
        }
        for (Authenticator authenticator : this.authMapper.getAuthenticatorChain()) {
            if (!(authenticator instanceof AnonymousAuthenticator) && !(authenticator instanceof AllowAllAuthenticator)) continue;
            log.info("Using Anonymous authentication", new Object[0]);
            return new AnonymousAuthServerInterceptor(authenticator);
        }
        String msg = "The gRPC query server requires either a Basic or Anonymous authorizer: it does not work with others yet.";
        log.error(msg, new Object[0]);
        throw new UOE(msg, new Object[0]);
    }

    public void stop() throws InterruptedException {
        if (this.server != null) {
            log.info("Server stopping", new Object[0]);
            this.healthService.unregisterService(QueryService.class.getSimpleName());
            this.healthService.unregisterService("");
            this.server.shutdown().awaitTermination(30L, TimeUnit.SECONDS);
        }
    }

    public void blockUntilShutdown() throws InterruptedException {
        if (this.server != null) {
            log.info("Grpc Server stopping", new Object[0]);
            this.healthService.unregisterService(QueryService.class.getSimpleName());
            this.healthService.unregisterService("");
            this.server.awaitTermination();
        }
    }
}

