/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.emitter.graphite;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provides;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.druid.emitter.graphite.GraphiteEmitter;
import org.apache.druid.emitter.graphite.GraphiteEmitterConfig;
import org.apache.druid.guice.JsonConfigProvider;
import org.apache.druid.guice.ManageLifecycle;
import org.apache.druid.initialization.DruidModule;
import org.apache.druid.java.util.emitter.core.Emitter;

public class GraphiteEmitterModule
implements DruidModule {
    private static final String EMITTER_TYPE = "graphite";

    public List<? extends Module> getJacksonModules() {
        return Collections.emptyList();
    }

    public void configure(Binder binder) {
        JsonConfigProvider.bind((Binder)binder, (String)"druid.emitter.graphite", GraphiteEmitterConfig.class);
    }

    @Provides
    @ManageLifecycle
    @Named(value="graphite")
    public Emitter getEmitter(GraphiteEmitterConfig graphiteEmitterConfig, ObjectMapper mapper, Injector injector) {
        ImmutableList emitters = ImmutableList.copyOf((Collection)Lists.transform(graphiteEmitterConfig.getAlertEmitters(), alertEmitterName -> (Emitter)injector.getInstance(Key.get(Emitter.class, (Annotation)Names.named((String)alertEmitterName)))));
        ImmutableList requestLogEmitters = ImmutableList.copyOf((Collection)Lists.transform(graphiteEmitterConfig.getRequestLogEmitters(), requestLogEmitterName -> (Emitter)injector.getInstance(Key.get(Emitter.class, (Annotation)Names.named((String)requestLogEmitterName)))));
        return new GraphiteEmitter(graphiteEmitterConfig, (List<Emitter>)emitters, (List<Emitter>)requestLogEmitters);
    }
}

