/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord.autoscaling.gce;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Objects;

public class GceEnvironmentConfig {
    private final int numInstances;
    private final String projectId;
    private final String zoneName;
    private final String managedInstanceGroupName;

    @JsonCreator
    public GceEnvironmentConfig(@JsonProperty(value="numInstances") int numInstances, @JsonProperty(value="projectId") String projectId, @JsonProperty(value="zoneName") String zoneName, @JsonProperty(value="managedInstanceGroupName") String managedInstanceGroupName) {
        Preconditions.checkArgument((numInstances > 0 ? 1 : 0) != 0, (Object)"numInstances must be greater than 0");
        this.numInstances = numInstances;
        this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"projectId must be not null");
        this.zoneName = (String)Preconditions.checkNotNull((Object)zoneName, (Object)"zoneName nust be not null");
        this.managedInstanceGroupName = (String)Preconditions.checkNotNull((Object)managedInstanceGroupName, (Object)"managedInstanceGroupName must be not null");
    }

    @JsonProperty
    public int getNumInstances() {
        return this.numInstances;
    }

    @JsonProperty
    String getZoneName() {
        return this.zoneName;
    }

    @JsonProperty
    String getProjectId() {
        return this.projectId;
    }

    @JsonProperty
    String getManagedInstanceGroupName() {
        return this.managedInstanceGroupName;
    }

    public String toString() {
        return "GceEnvironmentConfig={projectId=" + this.projectId + ", zoneName=" + this.zoneName + ", numInstances=" + this.numInstances + ", managedInstanceGroupName=" + this.managedInstanceGroupName + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GceEnvironmentConfig that = (GceEnvironmentConfig)o;
        return this.numInstances == that.numInstances && this.projectId.equals(that.projectId) && this.zoneName.equals(that.zoneName) && this.managedInstanceGroupName.equals(that.managedInstanceGroupName);
    }

    public int hashCode() {
        int result = 0;
        result = 31 * result + Objects.hashCode(this.projectId);
        result = 31 * result + Objects.hashCode(this.zoneName);
        result = 31 * result + Objects.hashCode(this.managedInstanceGroupName);
        result = 31 * result + this.numInstances;
        return result;
    }
}

