/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.IdLookup;
import org.apache.druid.segment.MapVirtualColumnDimensionSelector;
import org.apache.druid.segment.data.IndexedInts;

final class MapTypeMapVirtualColumnDimensionSelector
extends MapVirtualColumnDimensionSelector {
    MapTypeMapVirtualColumnDimensionSelector(DimensionSelector keySelector, DimensionSelector valueSelector) {
        super(keySelector, valueSelector);
    }

    public IndexedInts getRow() {
        throw new UnsupportedOperationException("Map column doesn't support getRow()");
    }

    public ValueMatcher makeValueMatcher(@Nullable String value) {
        return new ValueMatcher(){

            public boolean matches(boolean includeUnknown) {
                return false;
            }

            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
            }
        };
    }

    public ValueMatcher makeValueMatcher(DruidPredicateFactory predicateFactory) {
        return new ValueMatcher(){

            public boolean matches(boolean includeUnknown) {
                return false;
            }

            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
            }
        };
    }

    public int getValueCardinality() {
        return -1;
    }

    @Nullable
    public String lookupName(int id) {
        throw new UnsupportedOperationException("Map column doesn't support lookupName()");
    }

    public boolean nameLookupPossibleInAdvance() {
        return false;
    }

    @Nullable
    public IdLookup idLookup() {
        throw new UnsupportedOperationException("Map column doesn't support idLookup()");
    }

    public Object getObject() {
        DimensionSelector keySelector = this.getKeySelector();
        DimensionSelector valueSelector = this.getValueSelector();
        IndexedInts keyIndices = keySelector.getRow();
        IndexedInts valueIndices = valueSelector.getRow();
        int limit = Math.min(keyIndices.size(), valueIndices.size());
        return IntStream.range(0, limit).boxed().collect(Collectors.toMap(i -> keySelector.lookupName(keyIndices.get(i.intValue())), i -> valueSelector.lookupName(valueIndices.get(i.intValue()))));
    }

    public Class classOfObject() {
        return Map.class;
    }
}

