/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation;

import java.util.Comparator;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.TimestampAggregatorFactory;
import org.apache.druid.segment.BaseObjectColumnValueSelector;

public class TimestampAggregator
implements Aggregator {
    static final Comparator COMPARATOR = Comparator.comparingLong(n -> ((Number)n).longValue());
    private final BaseObjectColumnValueSelector selector;
    private final TimestampSpec timestampSpec;
    private final Comparator<Long> comparator;
    private final Long initValue;
    private long most;

    static Object combineValues(Comparator<Long> comparator, Object lhs, Object rhs) {
        if (comparator.compare(((Number)lhs).longValue(), ((Number)rhs).longValue()) > 0) {
            return lhs;
        }
        return rhs;
    }

    public TimestampAggregator(BaseObjectColumnValueSelector selector, TimestampSpec timestampSpec, Comparator<Long> comparator, Long initValue) {
        this.selector = selector;
        this.timestampSpec = timestampSpec;
        this.comparator = comparator;
        this.initValue = initValue;
        this.most = this.initValue;
    }

    public void aggregate() {
        Long value = TimestampAggregatorFactory.convertLong(this.timestampSpec, this.selector.getObject());
        if (value != null) {
            this.most = this.comparator.compare(this.most, value) > 0 ? this.most : value;
        }
    }

    public Object get() {
        return this.most;
    }

    public float getFloat() {
        return this.most;
    }

    public double getDouble() {
        return this.most;
    }

    public long getLong() {
        return this.most;
    }

    public void close() {
    }
}

