/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.redis.shaded.redis.clients.jedis.params;

import org.apache.druid.redis.shaded.redis.clients.jedis.CommandArguments;
import org.apache.druid.redis.shaded.redis.clients.jedis.Protocol;
import org.apache.druid.redis.shaded.redis.clients.jedis.params.IParams;

public class RestoreParams
implements IParams {
    private boolean replace;
    private boolean absTtl;
    private Long idleTime;
    private Long frequency;

    public static RestoreParams restoreParams() {
        return new RestoreParams();
    }

    public RestoreParams replace() {
        this.replace = true;
        return this;
    }

    public RestoreParams absTtl() {
        this.absTtl = true;
        return this;
    }

    public RestoreParams idleTime(long idleTime) {
        this.idleTime = idleTime;
        return this;
    }

    public RestoreParams frequency(long frequency) {
        this.frequency = frequency;
        return this;
    }

    @Override
    public void addParams(CommandArguments args) {
        if (this.replace) {
            args.add(Protocol.Keyword.REPLACE);
        }
        if (this.absTtl) {
            args.add(Protocol.Keyword.ABSTTL);
        }
        if (this.idleTime != null) {
            args.add(Protocol.Keyword.IDLETIME).add(this.idleTime);
        }
        if (this.frequency != null) {
            args.add(Protocol.Keyword.FREQ).add(this.frequency);
        }
    }
}

