/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.redis.shaded.redis.clients.jedis.mcf;

import java.io.Closeable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.apache.druid.redis.shaded.redis.clients.jedis.CommandArguments;
import org.apache.druid.redis.shaded.redis.clients.jedis.CommandObject;
import org.apache.druid.redis.shaded.redis.clients.jedis.CommandObjects;
import org.apache.druid.redis.shaded.redis.clients.jedis.Connection;
import org.apache.druid.redis.shaded.redis.clients.jedis.PipelineBase;
import org.apache.druid.redis.shaded.redis.clients.jedis.RedisProtocol;
import org.apache.druid.redis.shaded.redis.clients.jedis.Response;
import org.apache.druid.redis.shaded.redis.clients.jedis.graph.ResultSet;
import org.apache.druid.redis.shaded.redis.clients.jedis.mcf.CircuitBreakerFailoverConnectionProvider;
import org.apache.druid.redis.shaded.redis.clients.jedis.providers.MultiClusterPooledConnectionProvider;
import org.apache.druid.redis.shaded.redis.clients.jedis.util.KeyValue;

public class MultiClusterPipeline
extends PipelineBase
implements Closeable {
    private final CircuitBreakerFailoverConnectionProvider failoverProvider;
    private final Queue<KeyValue<CommandArguments, Response<?>>> commands = new LinkedList();

    @Deprecated
    public MultiClusterPipeline(MultiClusterPooledConnectionProvider pooledProvider) {
        super(new CommandObjects());
        this.failoverProvider = new CircuitBreakerFailoverConnectionProvider(pooledProvider);
        try (Connection connection = this.failoverProvider.getConnection();){
            RedisProtocol proto = connection.getRedisProtocol();
            if (proto != null) {
                this.commandObjects.setProtocol(proto);
            }
        }
    }

    public MultiClusterPipeline(MultiClusterPooledConnectionProvider pooledProvider, CommandObjects commandObjects) {
        super(commandObjects);
        this.failoverProvider = new CircuitBreakerFailoverConnectionProvider(pooledProvider);
    }

    @Override
    protected final <T> Response<T> appendCommand(CommandObject<T> commandObject) {
        CommandArguments args = commandObject.getArguments();
        Response<T> response = new Response<T>(commandObject.getBuilder());
        this.commands.add(KeyValue.of(args, response));
        return response;
    }

    @Override
    public void close() {
        this.sync();
    }

    @Override
    public void sync() {
        if (this.commands.isEmpty()) {
            return;
        }
        try (Connection connection = this.failoverProvider.getConnection();){
            this.commands.forEach(command -> connection.sendCommand((CommandArguments)command.getKey()));
            List<Object> unformatted = connection.getMany(this.commands.size());
            unformatted.forEach(rawReply -> ((Response)this.commands.poll().getValue()).set(rawReply));
        }
    }

    public Response<Long> waitReplicas(int replicas, long timeout) {
        return this.appendCommand(this.commandObjects.waitReplicas(replicas, timeout));
    }

    public Response<KeyValue<Long, Long>> waitAOF(long numLocal, long numReplicas, long timeout) {
        return this.appendCommand(this.commandObjects.waitAOF(numLocal, numReplicas, timeout));
    }

    @Override
    public Response<ResultSet> graphQuery(String name, String query) {
        throw new UnsupportedOperationException("Graph commands are not supported.");
    }

    @Override
    public Response<ResultSet> graphReadonlyQuery(String name, String query) {
        throw new UnsupportedOperationException("Graph commands are not supported.");
    }

    @Override
    public Response<ResultSet> graphQuery(String name, String query, long timeout) {
        throw new UnsupportedOperationException("Graph commands are not supported.");
    }

    @Override
    public Response<ResultSet> graphReadonlyQuery(String name, String query, long timeout) {
        throw new UnsupportedOperationException("Graph commands are not supported.");
    }

    @Override
    public Response<ResultSet> graphQuery(String name, String query, Map<String, Object> params) {
        throw new UnsupportedOperationException("Graph commands are not supported.");
    }

    @Override
    public Response<ResultSet> graphReadonlyQuery(String name, String query, Map<String, Object> params) {
        throw new UnsupportedOperationException("Graph commands are not supported.");
    }

    @Override
    public Response<ResultSet> graphQuery(String name, String query, Map<String, Object> params, long timeout) {
        throw new UnsupportedOperationException("Graph commands are not supported.");
    }

    @Override
    public Response<ResultSet> graphReadonlyQuery(String name, String query, Map<String, Object> params, long timeout) {
        throw new UnsupportedOperationException("Graph commands are not supported.");
    }

    @Override
    public Response<String> graphDelete(String name) {
        throw new UnsupportedOperationException("Graph commands are not supported.");
    }

    @Override
    public Response<List<String>> graphProfile(String graphName, String query) {
        throw new UnsupportedOperationException("Graph commands are not supported.");
    }
}

