/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.redis.shaded.redis.clients.jedis;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.druid.redis.shaded.redis.clients.jedis.Builder;
import org.apache.druid.redis.shaded.redis.clients.jedis.GeoCoordinate;
import org.apache.druid.redis.shaded.redis.clients.jedis.Module;
import org.apache.druid.redis.shaded.redis.clients.jedis.StreamEntryID;
import org.apache.druid.redis.shaded.redis.clients.jedis.exceptions.JedisDataException;
import org.apache.druid.redis.shaded.redis.clients.jedis.resps.AccessControlLogEntry;
import org.apache.druid.redis.shaded.redis.clients.jedis.resps.AccessControlUser;
import org.apache.druid.redis.shaded.redis.clients.jedis.resps.ClusterShardInfo;
import org.apache.druid.redis.shaded.redis.clients.jedis.resps.ClusterShardNodeInfo;
import org.apache.druid.redis.shaded.redis.clients.jedis.resps.CommandDocument;
import org.apache.druid.redis.shaded.redis.clients.jedis.resps.CommandInfo;
import org.apache.druid.redis.shaded.redis.clients.jedis.resps.GeoRadiusResponse;
import org.apache.druid.redis.shaded.redis.clients.jedis.resps.LCSMatchResult;
import org.apache.druid.redis.shaded.redis.clients.jedis.resps.LibraryInfo;
import org.apache.druid.redis.shaded.redis.clients.jedis.resps.ScanResult;
import org.apache.druid.redis.shaded.redis.clients.jedis.resps.StreamConsumerFullInfo;
import org.apache.druid.redis.shaded.redis.clients.jedis.resps.StreamConsumerInfo;
import org.apache.druid.redis.shaded.redis.clients.jedis.resps.StreamConsumersInfo;
import org.apache.druid.redis.shaded.redis.clients.jedis.resps.StreamEntry;
import org.apache.druid.redis.shaded.redis.clients.jedis.resps.StreamFullInfo;
import org.apache.druid.redis.shaded.redis.clients.jedis.resps.StreamGroupFullInfo;
import org.apache.druid.redis.shaded.redis.clients.jedis.resps.StreamGroupInfo;
import org.apache.druid.redis.shaded.redis.clients.jedis.resps.StreamInfo;
import org.apache.druid.redis.shaded.redis.clients.jedis.resps.StreamPendingEntry;
import org.apache.druid.redis.shaded.redis.clients.jedis.resps.StreamPendingSummary;
import org.apache.druid.redis.shaded.redis.clients.jedis.resps.Tuple;
import org.apache.druid.redis.shaded.redis.clients.jedis.util.DoublePrecision;
import org.apache.druid.redis.shaded.redis.clients.jedis.util.JedisByteHashMap;
import org.apache.druid.redis.shaded.redis.clients.jedis.util.KeyValue;
import org.apache.druid.redis.shaded.redis.clients.jedis.util.SafeEncoder;

public final class BuilderFactory {
    public static final Builder<Object> RAW_OBJECT = new Builder<Object>(){

        @Override
        public Object build(Object data) {
            return data;
        }

        public String toString() {
            return "Object";
        }
    };
    public static final Builder<List<Object>> RAW_OBJECT_LIST = new Builder<List<Object>>(){

        @Override
        public List<Object> build(Object data) {
            return (List)data;
        }

        public String toString() {
            return "List<Object>";
        }
    };
    public static final Builder<Object> ENCODED_OBJECT = new Builder<Object>(){

        @Override
        public Object build(Object data) {
            return SafeEncoder.encodeObject(data);
        }

        public String toString() {
            return "Object";
        }
    };
    public static final Builder<List<Object>> ENCODED_OBJECT_LIST = new Builder<List<Object>>(){

        @Override
        public List<Object> build(Object data) {
            return (List)SafeEncoder.encodeObject(data);
        }

        public String toString() {
            return "List<Object>";
        }
    };
    public static final Builder<Long> LONG = new Builder<Long>(){

        @Override
        public Long build(Object data) {
            return (Long)data;
        }

        public String toString() {
            return "Long";
        }
    };
    public static final Builder<List<Long>> LONG_LIST = new Builder<List<Long>>(){

        @Override
        public List<Long> build(Object data) {
            if (null == data) {
                return null;
            }
            return (List)data;
        }

        public String toString() {
            return "List<Long>";
        }
    };
    public static final Builder<Double> DOUBLE = new Builder<Double>(){

        @Override
        public Double build(Object data) {
            if (data == null) {
                return null;
            }
            if (data instanceof Double) {
                return (Double)data;
            }
            return DoublePrecision.parseFloatingPointNumber(STRING.build(data));
        }

        public String toString() {
            return "Double";
        }
    };
    public static final Builder<List<Double>> DOUBLE_LIST = new Builder<List<Double>>(){

        @Override
        public List<Double> build(Object data) {
            if (null == data) {
                return null;
            }
            return ((List)data).stream().map(DOUBLE::build).collect(Collectors.toList());
        }

        public String toString() {
            return "List<Double>";
        }
    };
    public static final Builder<Boolean> BOOLEAN = new Builder<Boolean>(){

        @Override
        public Boolean build(Object data) {
            if (data == null) {
                return null;
            }
            if (data instanceof Boolean) {
                return (Boolean)data;
            }
            return (Long)data == 1L;
        }

        public String toString() {
            return "Boolean";
        }
    };
    public static final Builder<List<Boolean>> BOOLEAN_LIST = new Builder<List<Boolean>>(){

        @Override
        public List<Boolean> build(Object data) {
            if (null == data) {
                return null;
            }
            return ((List)data).stream().map(BOOLEAN::build).collect(Collectors.toList());
        }

        public String toString() {
            return "List<Boolean>";
        }
    };
    public static final Builder<List<Boolean>> BOOLEAN_WITH_ERROR_LIST = new Builder<List<Boolean>>(){

        @Override
        public List<Boolean> build(Object data) {
            if (null == data) {
                return null;
            }
            return ((List)data).stream().map(val -> val instanceof JedisDataException ? null : BOOLEAN.build(val)).collect(Collectors.toList());
        }

        public String toString() {
            return "List<Boolean>";
        }
    };
    public static final Builder<byte[]> BINARY = new Builder<byte[]>(){

        @Override
        public byte[] build(Object data) {
            return (byte[])data;
        }

        public String toString() {
            return "byte[]";
        }
    };
    public static final Builder<List<byte[]>> BINARY_LIST = new Builder<List<byte[]>>(){

        @Override
        public List<byte[]> build(Object data) {
            return (List)data;
        }

        public String toString() {
            return "List<byte[]>";
        }
    };
    public static final Builder<Set<byte[]>> BINARY_SET = new Builder<Set<byte[]>>(){

        @Override
        public Set<byte[]> build(Object data) {
            if (null == data) {
                return null;
            }
            List<byte[]> l = BINARY_LIST.build(data);
            return SetFromList.of(l);
        }

        public String toString() {
            return "Set<byte[]>";
        }
    };
    public static final Builder<List<Map.Entry<byte[], byte[]>>> BINARY_PAIR_LIST = new Builder<List<Map.Entry<byte[], byte[]>>>(){

        @Override
        public List<Map.Entry<byte[], byte[]>> build(Object data) {
            List flatHash = (List)data;
            ArrayList<Map.Entry<byte[], byte[]>> pairList = new ArrayList<Map.Entry<byte[], byte[]>>();
            Iterator iterator = flatHash.iterator();
            while (iterator.hasNext()) {
                pairList.add(new AbstractMap.SimpleEntry(iterator.next(), iterator.next()));
            }
            return pairList;
        }

        public String toString() {
            return "List<Map.Entry<byte[], byte[]>>";
        }
    };
    public static final Builder<List<Map.Entry<byte[], byte[]>>> BINARY_PAIR_LIST_FROM_PAIRS = new Builder<List<Map.Entry<byte[], byte[]>>>(){

        @Override
        public List<Map.Entry<byte[], byte[]>> build(Object data) {
            List list = (List)data;
            ArrayList<Map.Entry<byte[], byte[]>> pairList = new ArrayList<Map.Entry<byte[], byte[]>>();
            for (Object object : list) {
                List flat = (List)object;
                pairList.add(new AbstractMap.SimpleEntry(flat.get(0), flat.get(1)));
            }
            return pairList;
        }

        public String toString() {
            return "List<Map.Entry<byte[], byte[]>>";
        }
    };
    public static final Builder<String> STRING = new Builder<String>(){

        @Override
        public String build(Object data) {
            return data == null ? null : SafeEncoder.encode((byte[])data);
        }

        public String toString() {
            return "String";
        }
    };
    public static final Builder<List<String>> STRING_LIST = new Builder<List<String>>(){

        @Override
        public List<String> build(Object data) {
            if (null == data) {
                return null;
            }
            return ((List)data).stream().map(STRING::build).collect(Collectors.toList());
        }

        public String toString() {
            return "List<String>";
        }
    };
    public static final Builder<Set<String>> STRING_SET = new Builder<Set<String>>(){

        @Override
        public Set<String> build(Object data) {
            if (null == data) {
                return null;
            }
            return ((List)data).stream().map(STRING::build).collect(Collectors.toSet());
        }

        public String toString() {
            return "Set<String>";
        }
    };
    public static final Builder<Map<byte[], byte[]>> BINARY_MAP = new Builder<Map<byte[], byte[]>>(){

        @Override
        public Map<byte[], byte[]> build(Object data) {
            List list = (List)data;
            if (list.isEmpty()) {
                return Collections.emptyMap();
            }
            if (list.get(0) instanceof KeyValue) {
                JedisByteHashMap map = new JedisByteHashMap();
                for (KeyValue kv : list) {
                    map.put(BINARY.build(kv.getKey()), BINARY.build(kv.getValue()));
                }
                return map;
            }
            JedisByteHashMap map = new JedisByteHashMap();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                map.put(BINARY.build(iterator.next()), BINARY.build(iterator.next()));
            }
            return map;
        }

        public String toString() {
            return "Map<byte[], byte[]>";
        }
    };
    public static final Builder<Map<String, String>> STRING_MAP = new Builder<Map<String, String>>(){

        @Override
        public Map<String, String> build(Object data) {
            List list = (List)data;
            if (list.isEmpty()) {
                return Collections.emptyMap();
            }
            if (list.get(0) instanceof KeyValue) {
                HashMap<String, String> map = new HashMap<String, String>(list.size(), 1.0f);
                for (KeyValue kv : list) {
                    map.put(STRING.build(kv.getKey()), STRING.build(kv.getValue()));
                }
                return map;
            }
            HashMap<String, String> map = new HashMap<String, String>(list.size() / 2, 1.0f);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                map.put(STRING.build(iterator.next()), STRING.build(iterator.next()));
            }
            return map;
        }

        public String toString() {
            return "Map<String, String>";
        }
    };
    public static final Builder<Map<String, Object>> ENCODED_OBJECT_MAP = new Builder<Map<String, Object>>(){

        @Override
        public Map<String, Object> build(Object data) {
            if (data == null) {
                return null;
            }
            List list = (List)data;
            if (list.isEmpty()) {
                return Collections.emptyMap();
            }
            if (list.get(0) instanceof KeyValue) {
                HashMap<String, Object> map = new HashMap<String, Object>(list.size(), 1.0f);
                for (KeyValue kv : list) {
                    map.put(STRING.build(kv.getKey()), ENCODED_OBJECT.build(kv.getValue()));
                }
                return map;
            }
            HashMap<String, Object> map = new HashMap<String, Object>(list.size() / 2, 1.0f);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                map.put(STRING.build(iterator.next()), ENCODED_OBJECT.build(iterator.next()));
            }
            return map;
        }
    };
    public static final Builder<Object> AGGRESSIVE_ENCODED_OBJECT = new Builder<Object>(){

        @Override
        public Object build(Object data) {
            if (data == null) {
                return null;
            }
            if (data instanceof List) {
                List list = (List)data;
                if (list.isEmpty()) {
                    return Collections.emptyMap();
                }
                if (list.get(0) instanceof KeyValue) {
                    return ((List)data).stream().filter(kv -> kv != null && kv.getKey() != null && kv.getValue() != null).collect(Collectors.toMap(kv -> STRING.build(kv.getKey()), kv -> this.build(kv.getValue())));
                }
                return list.stream().map(this::build).collect(Collectors.toList());
            }
            if (data instanceof byte[]) {
                return STRING.build(data);
            }
            return data;
        }
    };
    public static final Builder<Map<String, Object>> AGGRESSIVE_ENCODED_OBJECT_MAP = new Builder<Map<String, Object>>(){

        @Override
        public Map<String, Object> build(Object data) {
            return (Map)AGGRESSIVE_ENCODED_OBJECT.build(data);
        }
    };
    public static final Builder<List<Map.Entry<String, String>>> STRING_PAIR_LIST = new Builder<List<Map.Entry<String, String>>>(){

        @Override
        public List<Map.Entry<String, String>> build(Object data) {
            List flatHash = (List)data;
            ArrayList<Map.Entry<String, String>> pairList = new ArrayList<Map.Entry<String, String>>(flatHash.size() / 2);
            Iterator iterator = flatHash.iterator();
            while (iterator.hasNext()) {
                pairList.add(KeyValue.of(STRING.build(iterator.next()), STRING.build(iterator.next())));
            }
            return pairList;
        }

        public String toString() {
            return "List<Map.Entry<String, String>>";
        }
    };
    public static final Builder<List<Map.Entry<String, String>>> STRING_PAIR_LIST_FROM_PAIRS = new Builder<List<Map.Entry<String, String>>>(){

        @Override
        public List<Map.Entry<String, String>> build(Object data) {
            return ((List)data).stream().map(o -> (List)o).map(l -> KeyValue.of(STRING.build(l.get(0)), STRING.build(l.get(1)))).collect(Collectors.toList());
        }

        public String toString() {
            return "List<Map.Entry<String, String>>";
        }
    };
    public static final Builder<Map<String, Long>> STRING_LONG_MAP = new Builder<Map<String, Long>>(){

        @Override
        public Map<String, Long> build(Object data) {
            List list = (List)data;
            if (list.isEmpty()) {
                return Collections.emptyMap();
            }
            if (list.get(0) instanceof KeyValue) {
                LinkedHashMap<String, Long> map = new LinkedHashMap<String, Long>(list.size(), 1.0f);
                for (KeyValue kv : list) {
                    map.put(STRING.build(kv.getKey()), LONG.build(kv.getValue()));
                }
                return map;
            }
            LinkedHashMap<String, Long> map = new LinkedHashMap<String, Long>(list.size() / 2, 1.0f);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                map.put(STRING.build(iterator.next()), LONG.build(iterator.next()));
            }
            return map;
        }

        public String toString() {
            return "Map<String, Long>";
        }
    };
    public static final Builder<KeyValue<String, String>> KEYED_ELEMENT = new Builder<KeyValue<String, String>>(){

        @Override
        public KeyValue<String, String> build(Object data) {
            if (data == null) {
                return null;
            }
            List l = (List)data;
            return KeyValue.of(STRING.build(l.get(0)), STRING.build(l.get(1)));
        }

        public String toString() {
            return "KeyValue<String, String>";
        }
    };
    public static final Builder<KeyValue<byte[], byte[]>> BINARY_KEYED_ELEMENT = new Builder<KeyValue<byte[], byte[]>>(){

        @Override
        public KeyValue<byte[], byte[]> build(Object data) {
            if (data == null) {
                return null;
            }
            List l = (List)data;
            return KeyValue.of(BINARY.build(l.get(0)), BINARY.build(l.get(1)));
        }

        public String toString() {
            return "KeyValue<byte[], byte[]>";
        }
    };
    public static final Builder<KeyValue<Long, Double>> ZRANK_WITHSCORE_PAIR = new Builder<KeyValue<Long, Double>>(){

        @Override
        public KeyValue<Long, Double> build(Object data) {
            if (data == null) {
                return null;
            }
            List l = (List)data;
            return new KeyValue<Long, Double>(LONG.build(l.get(0)), DOUBLE.build(l.get(1)));
        }

        public String toString() {
            return "KeyValue<Long, Double>";
        }
    };
    public static final Builder<KeyValue<String, List<String>>> KEYED_STRING_LIST = new Builder<KeyValue<String, List<String>>>(){

        @Override
        public KeyValue<String, List<String>> build(Object data) {
            if (data == null) {
                return null;
            }
            List l = (List)data;
            return new KeyValue<String, List<String>>(STRING.build(l.get(0)), STRING_LIST.build(l.get(1)));
        }

        public String toString() {
            return "KeyValue<String, List<String>>";
        }
    };
    public static final Builder<KeyValue<Long, Long>> LONG_LONG_PAIR = new Builder<KeyValue<Long, Long>>(){

        @Override
        public KeyValue<Long, Long> build(Object data) {
            if (data == null) {
                return null;
            }
            List dataList = (List)data;
            return new KeyValue<Long, Long>(LONG.build(dataList.get(0)), LONG.build(dataList.get(1)));
        }
    };
    public static final Builder<List<KeyValue<String, List<String>>>> KEYED_STRING_LIST_LIST = new Builder<List<KeyValue<String, List<String>>>>(){

        @Override
        public List<KeyValue<String, List<String>>> build(Object data) {
            List list = (List)data;
            return list.stream().map(KEYED_STRING_LIST::build).collect(Collectors.toList());
        }
    };
    public static final Builder<KeyValue<byte[], List<byte[]>>> KEYED_BINARY_LIST = new Builder<KeyValue<byte[], List<byte[]>>>(){

        @Override
        public KeyValue<byte[], List<byte[]>> build(Object data) {
            if (data == null) {
                return null;
            }
            List l = (List)data;
            return new KeyValue<byte[], List<byte[]>>(BINARY.build(l.get(0)), BINARY_LIST.build(l.get(1)));
        }

        public String toString() {
            return "KeyValue<byte[], List<byte[]>>";
        }
    };
    public static final Builder<Tuple> TUPLE = new Builder<Tuple>(){

        @Override
        public Tuple build(Object data) {
            List l = (List)data;
            if (l.isEmpty()) {
                return null;
            }
            return new Tuple((byte[])l.get(0), DOUBLE.build(l.get(1)));
        }

        public String toString() {
            return "Tuple";
        }
    };
    public static final Builder<KeyValue<String, Tuple>> KEYED_TUPLE = new Builder<KeyValue<String, Tuple>>(){

        @Override
        public KeyValue<String, Tuple> build(Object data) {
            List l = (List)data;
            if (l.isEmpty()) {
                return null;
            }
            return KeyValue.of(STRING.build(l.get(0)), new Tuple(BINARY.build(l.get(1)), DOUBLE.build(l.get(2))));
        }

        public String toString() {
            return "KeyValue<String, Tuple>";
        }
    };
    public static final Builder<KeyValue<byte[], Tuple>> BINARY_KEYED_TUPLE = new Builder<KeyValue<byte[], Tuple>>(){

        @Override
        public KeyValue<byte[], Tuple> build(Object data) {
            List l = (List)data;
            if (l.isEmpty()) {
                return null;
            }
            return KeyValue.of(BINARY.build(l.get(0)), new Tuple(BINARY.build(l.get(1)), DOUBLE.build(l.get(2))));
        }

        public String toString() {
            return "KeyValue<byte[], Tuple>";
        }
    };
    public static final Builder<List<Tuple>> TUPLE_LIST = new Builder<List<Tuple>>(){

        @Override
        public List<Tuple> build(Object data) {
            if (null == data) {
                return null;
            }
            List l = (List)data;
            ArrayList<Tuple> result = new ArrayList<Tuple>(l.size() / 2);
            Iterator iterator = l.iterator();
            while (iterator.hasNext()) {
                result.add(new Tuple((byte[])iterator.next(), DOUBLE.build(iterator.next())));
            }
            return result;
        }

        public String toString() {
            return "List<Tuple>";
        }
    };
    public static final Builder<List<Tuple>> TUPLE_LIST_RESP3 = new Builder<List<Tuple>>(){

        @Override
        public List<Tuple> build(Object data) {
            if (null == data) {
                return null;
            }
            return ((List)data).stream().map(TUPLE::build).collect(Collectors.toList());
        }

        public String toString() {
            return "List<Tuple>";
        }
    };
    public static final Builder<Set<Tuple>> TUPLE_ZSET = new Builder<Set<Tuple>>(){

        @Override
        public Set<Tuple> build(Object data) {
            if (null == data) {
                return null;
            }
            List l = (List)data;
            LinkedHashSet<Tuple> result = new LinkedHashSet<Tuple>(l.size() / 2, 1.0f);
            Iterator iterator = l.iterator();
            while (iterator.hasNext()) {
                result.add(new Tuple((byte[])iterator.next(), DOUBLE.build(iterator.next())));
            }
            return result;
        }

        public String toString() {
            return "ZSet<Tuple>";
        }
    };
    public static final Builder<Set<Tuple>> TUPLE_ZSET_RESP3 = new Builder<Set<Tuple>>(){

        @Override
        public Set<Tuple> build(Object data) {
            if (null == data) {
                return null;
            }
            return ((List)data).stream().map(TUPLE::build).collect(Collectors.toCollection(LinkedHashSet::new));
        }

        public String toString() {
            return "ZSet<Tuple>";
        }
    };
    private static final Builder<List<Tuple>> TUPLE_LIST_FROM_PAIRS = new Builder<List<Tuple>>(){

        @Override
        public List<Tuple> build(Object data) {
            if (data == null) {
                return null;
            }
            return ((List)data).stream().map(TUPLE::build).collect(Collectors.toList());
        }

        public String toString() {
            return "List<Tuple>";
        }
    };
    public static final Builder<KeyValue<String, List<Tuple>>> KEYED_TUPLE_LIST = new Builder<KeyValue<String, List<Tuple>>>(){

        @Override
        public KeyValue<String, List<Tuple>> build(Object data) {
            if (data == null) {
                return null;
            }
            List l = (List)data;
            return new KeyValue<String, List<Tuple>>(STRING.build(l.get(0)), (List<Tuple>)TUPLE_LIST_FROM_PAIRS.build(l.get(1)));
        }

        public String toString() {
            return "KeyValue<String, List<Tuple>>";
        }
    };
    public static final Builder<KeyValue<byte[], List<Tuple>>> BINARY_KEYED_TUPLE_LIST = new Builder<KeyValue<byte[], List<Tuple>>>(){

        @Override
        public KeyValue<byte[], List<Tuple>> build(Object data) {
            if (data == null) {
                return null;
            }
            List l = (List)data;
            return new KeyValue<byte[], List<Tuple>>(BINARY.build(l.get(0)), (List<Tuple>)TUPLE_LIST_FROM_PAIRS.build(l.get(1)));
        }

        public String toString() {
            return "KeyValue<byte[], List<Tuple>>";
        }
    };
    public static final Builder<ScanResult<String>> SCAN_RESPONSE = new Builder<ScanResult<String>>(){

        @Override
        public ScanResult<String> build(Object data) {
            List result = (List)data;
            String newcursor = new String((byte[])result.get(0));
            List rawResults = (List)result.get(1);
            ArrayList<String> results = new ArrayList<String>(rawResults.size());
            for (byte[] bs : rawResults) {
                results.add(SafeEncoder.encode(bs));
            }
            return new ScanResult<String>(newcursor, results);
        }
    };
    public static final Builder<ScanResult<Map.Entry<String, String>>> HSCAN_RESPONSE = new Builder<ScanResult<Map.Entry<String, String>>>(){

        @Override
        public ScanResult<Map.Entry<String, String>> build(Object data) {
            List result = (List)data;
            String newcursor = new String((byte[])result.get(0));
            List rawResults = (List)result.get(1);
            ArrayList<AbstractMap.SimpleEntry<String, String>> results = new ArrayList<AbstractMap.SimpleEntry<String, String>>(rawResults.size() / 2);
            Iterator iterator = rawResults.iterator();
            while (iterator.hasNext()) {
                results.add(new AbstractMap.SimpleEntry<String, String>(SafeEncoder.encode((byte[])iterator.next()), SafeEncoder.encode((byte[])iterator.next())));
            }
            return new ScanResult<Map.Entry<String, String>>(newcursor, results);
        }
    };
    public static final Builder<ScanResult<String>> SSCAN_RESPONSE = new Builder<ScanResult<String>>(){

        @Override
        public ScanResult<String> build(Object data) {
            List result = (List)data;
            String newcursor = new String((byte[])result.get(0));
            List rawResults = (List)result.get(1);
            ArrayList<String> results = new ArrayList<String>(rawResults.size());
            for (byte[] bs : rawResults) {
                results.add(SafeEncoder.encode(bs));
            }
            return new ScanResult<String>(newcursor, results);
        }
    };
    public static final Builder<ScanResult<Tuple>> ZSCAN_RESPONSE = new Builder<ScanResult<Tuple>>(){

        @Override
        public ScanResult<Tuple> build(Object data) {
            List result = (List)data;
            String newcursor = new String((byte[])result.get(0));
            List rawResults = (List)result.get(1);
            ArrayList<Tuple> results = new ArrayList<Tuple>(rawResults.size() / 2);
            Iterator iterator = rawResults.iterator();
            while (iterator.hasNext()) {
                results.add(new Tuple((byte[])iterator.next(), DOUBLE.build(iterator.next())));
            }
            return new ScanResult<Tuple>(newcursor, results);
        }
    };
    public static final Builder<ScanResult<byte[]>> SCAN_BINARY_RESPONSE = new Builder<ScanResult<byte[]>>(){

        @Override
        public ScanResult<byte[]> build(Object data) {
            List result = (List)data;
            byte[] newcursor = (byte[])result.get(0);
            List rawResults = (List)result.get(1);
            return new ScanResult<byte[]>(newcursor, rawResults);
        }
    };
    public static final Builder<ScanResult<Map.Entry<byte[], byte[]>>> HSCAN_BINARY_RESPONSE = new Builder<ScanResult<Map.Entry<byte[], byte[]>>>(){

        @Override
        public ScanResult<Map.Entry<byte[], byte[]>> build(Object data) {
            List result = (List)data;
            byte[] newcursor = (byte[])result.get(0);
            List rawResults = (List)result.get(1);
            ArrayList results = new ArrayList(rawResults.size() / 2);
            Iterator iterator = rawResults.iterator();
            while (iterator.hasNext()) {
                results.add(new AbstractMap.SimpleEntry(iterator.next(), iterator.next()));
            }
            return new ScanResult<Map.Entry<byte[], byte[]>>(newcursor, results);
        }
    };
    public static final Builder<ScanResult<byte[]>> SSCAN_BINARY_RESPONSE = new Builder<ScanResult<byte[]>>(){

        @Override
        public ScanResult<byte[]> build(Object data) {
            List result = (List)data;
            byte[] newcursor = (byte[])result.get(0);
            List rawResults = (List)result.get(1);
            return new ScanResult<byte[]>(newcursor, rawResults);
        }
    };
    public static final Builder<Map<String, Long>> PUBSUB_NUMSUB_MAP = new Builder<Map<String, Long>>(){

        @Override
        public Map<String, Long> build(Object data) {
            List flatHash = (List)data;
            HashMap<String, Long> hash = new HashMap<String, Long>(flatHash.size() / 2, 1.0f);
            Iterator iterator = flatHash.iterator();
            while (iterator.hasNext()) {
                hash.put(SafeEncoder.encode((byte[])iterator.next()), (Long)iterator.next());
            }
            return hash;
        }

        public String toString() {
            return "PUBSUB_NUMSUB_MAP<String, String>";
        }
    };
    public static final Builder<List<GeoCoordinate>> GEO_COORDINATE_LIST = new Builder<List<GeoCoordinate>>(){

        @Override
        public List<GeoCoordinate> build(Object data) {
            if (null == data) {
                return null;
            }
            return this.interpretGeoposResult((List)data);
        }

        public String toString() {
            return "List<GeoCoordinate>";
        }

        private List<GeoCoordinate> interpretGeoposResult(List<Object> responses) {
            ArrayList<GeoCoordinate> responseCoordinate = new ArrayList<GeoCoordinate>(responses.size());
            for (Object response : responses) {
                if (response == null) {
                    responseCoordinate.add(null);
                    continue;
                }
                List respList = (List)response;
                GeoCoordinate coord = new GeoCoordinate(DOUBLE.build(respList.get(0)), DOUBLE.build(respList.get(1)));
                responseCoordinate.add(coord);
            }
            return responseCoordinate;
        }
    };
    public static final Builder<List<GeoRadiusResponse>> GEORADIUS_WITH_PARAMS_RESULT = new Builder<List<GeoRadiusResponse>>(){

        @Override
        public List<GeoRadiusResponse> build(Object data) {
            if (data == null) {
                return null;
            }
            List objectList = (List)data;
            ArrayList<GeoRadiusResponse> responses = new ArrayList<GeoRadiusResponse>(objectList.size());
            if (objectList.isEmpty()) {
                return responses;
            }
            if (objectList.get(0) instanceof List) {
                for (Object obj : objectList) {
                    List informations = (List)obj;
                    GeoRadiusResponse resp = new GeoRadiusResponse((byte[])informations.get(0));
                    int size = informations.size();
                    for (int idx = 1; idx < size; ++idx) {
                        Object info = informations.get(idx);
                        if (info instanceof List) {
                            List coord = (List)info;
                            resp.setCoordinate(new GeoCoordinate(DOUBLE.build(coord.get(0)), DOUBLE.build(coord.get(1))));
                            continue;
                        }
                        if (info instanceof Long) {
                            resp.setRawScore(LONG.build(info));
                            continue;
                        }
                        resp.setDistance(DOUBLE.build(info));
                    }
                    responses.add(resp);
                }
            } else {
                for (Object obj : objectList) {
                    responses.add(new GeoRadiusResponse((byte[])obj));
                }
            }
            return responses;
        }

        public String toString() {
            return "GeoRadiusWithParamsResult";
        }
    };
    public static final Builder<Map<String, CommandDocument>> COMMAND_DOCS_RESPONSE = new Builder<Map<String, CommandDocument>>(){

        @Override
        public Map<String, CommandDocument> build(Object data) {
            if (data == null) {
                return null;
            }
            List list = (List)data;
            if (list.isEmpty()) {
                return Collections.emptyMap();
            }
            if (list.get(0) instanceof KeyValue) {
                HashMap<String, CommandDocument> map = new HashMap<String, CommandDocument>(list.size(), 1.0f);
                for (KeyValue kv : list) {
                    map.put(STRING.build(kv.getKey()), new CommandDocument(ENCODED_OBJECT_MAP.build(kv.getValue())));
                }
                return map;
            }
            HashMap<String, CommandDocument> map = new HashMap<String, CommandDocument>(list.size() / 2, 1.0f);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                map.put(STRING.build(iterator.next()), new CommandDocument(ENCODED_OBJECT_MAP.build(iterator.next())));
            }
            return map;
        }
    };
    public static final Builder<Map<String, CommandInfo>> COMMAND_INFO_RESPONSE = new Builder<Map<String, CommandInfo>>(){

        @Override
        public Map<String, CommandInfo> build(Object data) {
            if (data == null) {
                return null;
            }
            List rawList = (List)data;
            HashMap<String, CommandInfo> map = new HashMap<String, CommandInfo>(rawList.size());
            for (Object rawCommandInfo : rawList) {
                if (rawCommandInfo == null) continue;
                List commandInfo = (List)rawCommandInfo;
                String name = STRING.build(commandInfo.get(0));
                CommandInfo info = CommandInfo.COMMAND_INFO_BUILDER.build(commandInfo);
                map.put(name, info);
            }
            return map;
        }
    };
    private static final Builder<List<List<Long>>> CLUSTER_SHARD_SLOTS_RANGES = new Builder<List<List<Long>>>(){

        @Override
        public List<List<Long>> build(Object data) {
            if (null == data) {
                return null;
            }
            List rawSlots = (List)data;
            ArrayList<List<Long>> slotsRanges = new ArrayList<List<Long>>();
            for (int i = 0; i < rawSlots.size(); i += 2) {
                slotsRanges.add(Arrays.asList((Long)rawSlots.get(i), (Long)rawSlots.get(i + 1)));
            }
            return slotsRanges;
        }
    };
    private static final Builder<List<ClusterShardNodeInfo>> CLUSTER_SHARD_NODE_INFO_LIST = new Builder<List<ClusterShardNodeInfo>>(){
        final Map<String, Builder> mappingFunctions = this.createDecoderMap();

        private Map<String, Builder> createDecoderMap() {
            HashMap<String, Builder> tempMappingFunctions = new HashMap<String, Builder>();
            tempMappingFunctions.put("id", STRING);
            tempMappingFunctions.put("endpoint", STRING);
            tempMappingFunctions.put("ip", STRING);
            tempMappingFunctions.put("hostname", STRING);
            tempMappingFunctions.put("port", LONG);
            tempMappingFunctions.put("tls-port", LONG);
            tempMappingFunctions.put("role", STRING);
            tempMappingFunctions.put("replication-offset", LONG);
            tempMappingFunctions.put("health", STRING);
            return tempMappingFunctions;
        }

        @Override
        public List<ClusterShardNodeInfo> build(Object data) {
            if (null == data) {
                return null;
            }
            ArrayList<ClusterShardNodeInfo> response = new ArrayList<ClusterShardNodeInfo>();
            List clusterShardNodeInfos = (List)data;
            for (Object clusterShardNodeInfoObject : clusterShardNodeInfos) {
                List clusterShardNodeInfo = (List)clusterShardNodeInfoObject;
                Iterator iterator = clusterShardNodeInfo.iterator();
                response.add(new ClusterShardNodeInfo(BuilderFactory.createMapFromDecodingFunctions(iterator, this.mappingFunctions)));
            }
            return response;
        }

        public String toString() {
            return "List<ClusterShardNodeInfo>";
        }
    };
    public static final Builder<List<ClusterShardInfo>> CLUSTER_SHARD_INFO_LIST = new Builder<List<ClusterShardInfo>>(){
        final Map<String, Builder> mappingFunctions = this.createDecoderMap();

        private Map<String, Builder> createDecoderMap() {
            HashMap<String, Builder> tempMappingFunctions = new HashMap<String, Builder>();
            tempMappingFunctions.put("slots", CLUSTER_SHARD_SLOTS_RANGES);
            tempMappingFunctions.put("nodes", CLUSTER_SHARD_NODE_INFO_LIST);
            return tempMappingFunctions;
        }

        @Override
        public List<ClusterShardInfo> build(Object data) {
            if (null == data) {
                return null;
            }
            ArrayList<ClusterShardInfo> response = new ArrayList<ClusterShardInfo>();
            List clusterShardInfos = (List)data;
            for (Object clusterShardInfoObject : clusterShardInfos) {
                List clusterShardInfo = (List)clusterShardInfoObject;
                Iterator iterator = clusterShardInfo.iterator();
                response.add(new ClusterShardInfo(BuilderFactory.createMapFromDecodingFunctions(iterator, this.mappingFunctions)));
            }
            return response;
        }

        public String toString() {
            return "List<ClusterShardInfo>";
        }
    };
    public static final Builder<List<Module>> MODULE_LIST = new Builder<List<Module>>(){

        @Override
        public List<Module> build(Object data) {
            if (data == null) {
                return null;
            }
            List objectList = (List)data;
            ArrayList<Module> responses = new ArrayList<Module>(objectList.size());
            if (objectList.isEmpty()) {
                return responses;
            }
            for (List moduleResp : objectList) {
                if (moduleResp.get(0) instanceof KeyValue) {
                    responses.add(new Module(STRING.build(((KeyValue)moduleResp.get(0)).getValue()), LONG.build(((KeyValue)moduleResp.get(1)).getValue()).intValue()));
                    continue;
                }
                Module m = new Module(SafeEncoder.encode((byte[])moduleResp.get(1)), ((Long)moduleResp.get(3)).intValue());
                responses.add(m);
            }
            return responses;
        }

        public String toString() {
            return "List<Module>";
        }
    };
    public static final Builder<AccessControlUser> ACCESS_CONTROL_USER = new Builder<AccessControlUser>(){

        @Override
        public AccessControlUser build(Object data) {
            Map<String, Object> map = ENCODED_OBJECT_MAP.build(data);
            if (map == null) {
                return null;
            }
            return new AccessControlUser(map);
        }

        public String toString() {
            return "AccessControlUser";
        }
    };
    public static final Builder<List<AccessControlLogEntry>> ACCESS_CONTROL_LOG_ENTRY_LIST = new Builder<List<AccessControlLogEntry>>(){
        private final Map<String, Builder> mappingFunctions = this.createDecoderMap();

        private Map<String, Builder> createDecoderMap() {
            HashMap<String, Builder> tempMappingFunctions = new HashMap<String, Builder>();
            tempMappingFunctions.put("count", LONG);
            tempMappingFunctions.put("reason", STRING);
            tempMappingFunctions.put("context", STRING);
            tempMappingFunctions.put("object", STRING);
            tempMappingFunctions.put("username", STRING);
            tempMappingFunctions.put("age-seconds", DOUBLE);
            tempMappingFunctions.put("client-info", STRING);
            tempMappingFunctions.put("entry-id", LONG);
            tempMappingFunctions.put("timestamp-created", LONG);
            tempMappingFunctions.put("timestamp-last-updated", LONG);
            return tempMappingFunctions;
        }

        @Override
        public List<AccessControlLogEntry> build(Object data) {
            if (null == data) {
                return null;
            }
            ArrayList<AccessControlLogEntry> list = new ArrayList<AccessControlLogEntry>();
            List logEntries = (List)data;
            for (List logEntryData : logEntries) {
                Iterator logEntryDataIterator = logEntryData.iterator();
                AccessControlLogEntry accessControlLogEntry = new AccessControlLogEntry(BuilderFactory.createMapFromDecodingFunctions(logEntryDataIterator, this.mappingFunctions, BACKUP_BUILDERS_FOR_DECODING_FUNCTIONS));
                list.add(accessControlLogEntry);
            }
            return list;
        }

        public String toString() {
            return "List<AccessControlLogEntry>";
        }
    };
    public static final Builder<StreamEntryID> STREAM_ENTRY_ID = new Builder<StreamEntryID>(){

        @Override
        public StreamEntryID build(Object data) {
            if (null == data) {
                return null;
            }
            String id = SafeEncoder.encode((byte[])data);
            return new StreamEntryID(id);
        }

        public String toString() {
            return "StreamEntryID";
        }
    };
    public static final Builder<List<StreamEntryID>> STREAM_ENTRY_ID_LIST = new Builder<List<StreamEntryID>>(){

        @Override
        public List<StreamEntryID> build(Object data) {
            if (null == data) {
                return null;
            }
            List objectList = (List)data;
            ArrayList<StreamEntryID> responses = new ArrayList<StreamEntryID>(objectList.size());
            if (!objectList.isEmpty()) {
                for (Object object : objectList) {
                    responses.add(STREAM_ENTRY_ID.build(object));
                }
            }
            return responses;
        }
    };
    public static final Builder<StreamEntry> STREAM_ENTRY = new Builder<StreamEntry>(){

        @Override
        public StreamEntry build(Object data) {
            if (null == data) {
                return null;
            }
            List objectList = (List)data;
            if (objectList.isEmpty()) {
                return null;
            }
            String entryIdString = SafeEncoder.encode((byte[])objectList.get(0));
            StreamEntryID entryID = new StreamEntryID(entryIdString);
            List hash = (List)objectList.get(1);
            Iterator hashIterator = hash.iterator();
            HashMap<String, String> map = new HashMap<String, String>(hash.size() / 2, 1.0f);
            while (hashIterator.hasNext()) {
                map.put(SafeEncoder.encode((byte[])hashIterator.next()), SafeEncoder.encode((byte[])hashIterator.next()));
            }
            return new StreamEntry(entryID, map);
        }

        public String toString() {
            return "StreamEntry";
        }
    };
    public static final Builder<List<StreamEntry>> STREAM_ENTRY_LIST = new Builder<List<StreamEntry>>(){

        @Override
        public List<StreamEntry> build(Object data) {
            if (null == data) {
                return null;
            }
            List objectList = (List)data;
            ArrayList<StreamEntry> responses = new ArrayList<StreamEntry>(objectList.size() / 2);
            if (objectList.isEmpty()) {
                return responses;
            }
            for (ArrayList res : objectList) {
                if (res == null) {
                    responses.add(null);
                    continue;
                }
                String entryIdString = SafeEncoder.encode((byte[])res.get(0));
                StreamEntryID entryID = new StreamEntryID(entryIdString);
                List hash = (List)res.get(1);
                if (hash == null) {
                    responses.add(new StreamEntry(entryID, null));
                    continue;
                }
                Iterator hashIterator = hash.iterator();
                HashMap<String, String> map = new HashMap<String, String>(hash.size() / 2, 1.0f);
                while (hashIterator.hasNext()) {
                    map.put(SafeEncoder.encode((byte[])hashIterator.next()), SafeEncoder.encode((byte[])hashIterator.next()));
                }
                responses.add(new StreamEntry(entryID, map));
            }
            return responses;
        }

        public String toString() {
            return "List<StreamEntry>";
        }
    };
    public static final Builder<Map.Entry<StreamEntryID, List<StreamEntry>>> STREAM_AUTO_CLAIM_RESPONSE = new Builder<Map.Entry<StreamEntryID, List<StreamEntry>>>(){

        @Override
        public Map.Entry<StreamEntryID, List<StreamEntry>> build(Object data) {
            if (null == data) {
                return null;
            }
            List objectList = (List)data;
            return new AbstractMap.SimpleEntry<StreamEntryID, List<StreamEntry>>(STREAM_ENTRY_ID.build(objectList.get(0)), STREAM_ENTRY_LIST.build(objectList.get(1)));
        }

        public String toString() {
            return "Map.Entry<StreamEntryID, List<StreamEntry>>";
        }
    };
    public static final Builder<Map.Entry<StreamEntryID, List<StreamEntryID>>> STREAM_AUTO_CLAIM_JUSTID_RESPONSE = new Builder<Map.Entry<StreamEntryID, List<StreamEntryID>>>(){

        @Override
        public Map.Entry<StreamEntryID, List<StreamEntryID>> build(Object data) {
            if (null == data) {
                return null;
            }
            List objectList = (List)data;
            return new AbstractMap.SimpleEntry<StreamEntryID, List<StreamEntryID>>(STREAM_ENTRY_ID.build(objectList.get(0)), STREAM_ENTRY_ID_LIST.build(objectList.get(1)));
        }

        public String toString() {
            return "Map.Entry<StreamEntryID, List<StreamEntryID>>";
        }
    };
    @Deprecated
    public static final Builder<Map.Entry<StreamEntryID, List<StreamEntryID>>> STREAM_AUTO_CLAIM_ID_RESPONSE = STREAM_AUTO_CLAIM_JUSTID_RESPONSE;
    public static final Builder<List<Map.Entry<String, List<StreamEntry>>>> STREAM_READ_RESPONSE = new Builder<List<Map.Entry<String, List<StreamEntry>>>>(){

        @Override
        public List<Map.Entry<String, List<StreamEntry>>> build(Object data) {
            if (data == null) {
                return null;
            }
            List list = (List)data;
            if (list.isEmpty()) {
                return Collections.emptyList();
            }
            if (list.get(0) instanceof KeyValue) {
                return list.stream().map(kv -> new KeyValue<String, List<StreamEntry>>(STRING.build(kv.getKey()), STREAM_ENTRY_LIST.build(kv.getValue()))).collect(Collectors.toList());
            }
            ArrayList<Map.Entry<String, List<StreamEntry>>> result = new ArrayList<Map.Entry<String, List<StreamEntry>>>(list.size());
            for (Object streamObj : list) {
                List stream = (List)streamObj;
                String streamKey = STRING.build(stream.get(0));
                List<StreamEntry> streamEntries = STREAM_ENTRY_LIST.build(stream.get(1));
                result.add(KeyValue.of(streamKey, streamEntries));
            }
            return result;
        }

        public String toString() {
            return "List<Entry<String, List<StreamEntry>>>";
        }
    };
    public static final Builder<List<StreamPendingEntry>> STREAM_PENDING_ENTRY_LIST = new Builder<List<StreamPendingEntry>>(){

        @Override
        public List<StreamPendingEntry> build(Object data) {
            if (null == data) {
                return null;
            }
            List streamsEntries = (List)data;
            ArrayList<StreamPendingEntry> result = new ArrayList<StreamPendingEntry>(streamsEntries.size());
            for (Object streamObj : streamsEntries) {
                List stream = (List)streamObj;
                String id = SafeEncoder.encode((byte[])stream.get(0));
                String consumerName = SafeEncoder.encode((byte[])stream.get(1));
                long idleTime = LONG.build(stream.get(2));
                long deliveredTimes = LONG.build(stream.get(3));
                result.add(new StreamPendingEntry(new StreamEntryID(id), consumerName, idleTime, deliveredTimes));
            }
            return result;
        }

        public String toString() {
            return "List<StreamPendingEntry>";
        }
    };
    public static final Builder<StreamInfo> STREAM_INFO = new Builder<StreamInfo>(){
        Map<String, Builder> mappingFunctions = this.createDecoderMap();

        private Map<String, Builder> createDecoderMap() {
            HashMap<String, Builder> tempMappingFunctions = new HashMap<String, Builder>();
            tempMappingFunctions.put("last-generated-id", STREAM_ENTRY_ID);
            tempMappingFunctions.put("first-entry", STREAM_ENTRY);
            tempMappingFunctions.put("length", LONG);
            tempMappingFunctions.put("radix-tree-keys", LONG);
            tempMappingFunctions.put("radix-tree-nodes", LONG);
            tempMappingFunctions.put("last-entry", STREAM_ENTRY);
            tempMappingFunctions.put("groups", LONG);
            return tempMappingFunctions;
        }

        @Override
        public StreamInfo build(Object data) {
            if (null == data) {
                return null;
            }
            List streamsEntries = (List)data;
            Iterator iterator = streamsEntries.iterator();
            return new StreamInfo(BuilderFactory.createMapFromDecodingFunctions(iterator, this.mappingFunctions));
        }

        public String toString() {
            return "StreamInfo";
        }
    };
    public static final Builder<List<StreamGroupInfo>> STREAM_GROUP_INFO_LIST = new Builder<List<StreamGroupInfo>>(){
        Map<String, Builder> mappingFunctions = this.createDecoderMap();

        private Map<String, Builder> createDecoderMap() {
            HashMap<String, Builder> tempMappingFunctions = new HashMap<String, Builder>();
            tempMappingFunctions.put("name", STRING);
            tempMappingFunctions.put("consumers", LONG);
            tempMappingFunctions.put("pending", LONG);
            tempMappingFunctions.put("last-delivered-id", STREAM_ENTRY_ID);
            return tempMappingFunctions;
        }

        @Override
        public List<StreamGroupInfo> build(Object data) {
            if (null == data) {
                return null;
            }
            ArrayList<StreamGroupInfo> list = new ArrayList<StreamGroupInfo>();
            List streamsEntries = (List)data;
            for (List groupInfo : streamsEntries) {
                Iterator groupInfoIterator = groupInfo.iterator();
                StreamGroupInfo streamGroupInfo = new StreamGroupInfo(BuilderFactory.createMapFromDecodingFunctions(groupInfoIterator, this.mappingFunctions));
                list.add(streamGroupInfo);
            }
            return list;
        }

        public String toString() {
            return "List<StreamGroupInfo>";
        }
    };
    @Deprecated
    public static final Builder<List<StreamConsumersInfo>> STREAM_CONSUMERS_INFO_LIST = new Builder<List<StreamConsumersInfo>>(){
        Map<String, Builder> mappingFunctions = this.createDecoderMap();

        private Map<String, Builder> createDecoderMap() {
            HashMap<String, Builder> tempMappingFunctions = new HashMap<String, Builder>();
            tempMappingFunctions.put("name", STRING);
            tempMappingFunctions.put("idle", LONG);
            tempMappingFunctions.put("pending", LONG);
            return tempMappingFunctions;
        }

        @Override
        public List<StreamConsumersInfo> build(Object data) {
            if (null == data) {
                return null;
            }
            ArrayList<StreamConsumersInfo> list = new ArrayList<StreamConsumersInfo>();
            List streamsEntries = (List)data;
            for (List groupInfo : streamsEntries) {
                Iterator consumerInfoIterator = groupInfo.iterator();
                StreamConsumersInfo streamGroupInfo = new StreamConsumersInfo(BuilderFactory.createMapFromDecodingFunctions(consumerInfoIterator, this.mappingFunctions));
                list.add(streamGroupInfo);
            }
            return list;
        }

        public String toString() {
            return "List<StreamConsumersInfo>";
        }
    };
    public static final Builder<List<StreamConsumerInfo>> STREAM_CONSUMER_INFO_LIST = new Builder<List<StreamConsumerInfo>>(){
        Map<String, Builder> mappingFunctions = this.createDecoderMap();

        private Map<String, Builder> createDecoderMap() {
            HashMap<String, Builder> tempMappingFunctions = new HashMap<String, Builder>();
            tempMappingFunctions.put("name", STRING);
            tempMappingFunctions.put("idle", LONG);
            tempMappingFunctions.put("pending", LONG);
            return tempMappingFunctions;
        }

        @Override
        public List<StreamConsumerInfo> build(Object data) {
            if (null == data) {
                return null;
            }
            ArrayList<StreamConsumerInfo> list = new ArrayList<StreamConsumerInfo>();
            List streamsEntries = (List)data;
            for (List groupInfo : streamsEntries) {
                Iterator consumerInfoIterator = groupInfo.iterator();
                StreamConsumerInfo streamConsumerInfo = new StreamConsumerInfo(BuilderFactory.createMapFromDecodingFunctions(consumerInfoIterator, this.mappingFunctions));
                list.add(streamConsumerInfo);
            }
            return list;
        }

        public String toString() {
            return "List<StreamConsumerInfo>";
        }
    };
    private static final Builder<List<StreamConsumerFullInfo>> STREAM_CONSUMER_FULL_INFO_LIST = new Builder<List<StreamConsumerFullInfo>>(){
        final Map<String, Builder> mappingFunctions = this.createDecoderMap();

        private Map<String, Builder> createDecoderMap() {
            HashMap<String, Builder> tempMappingFunctions = new HashMap<String, Builder>();
            tempMappingFunctions.put("name", STRING);
            tempMappingFunctions.put("seen-time", LONG);
            tempMappingFunctions.put("pel-count", LONG);
            tempMappingFunctions.put("pending", ENCODED_OBJECT_LIST);
            return tempMappingFunctions;
        }

        @Override
        public List<StreamConsumerFullInfo> build(Object data) {
            if (null == data) {
                return null;
            }
            ArrayList<StreamConsumerFullInfo> list = new ArrayList<StreamConsumerFullInfo>();
            List streamsEntries = (List)data;
            for (Object streamsEntry : streamsEntries) {
                List consumerInfoList = (List)streamsEntry;
                Iterator consumerInfoIterator = consumerInfoList.iterator();
                StreamConsumerFullInfo consumerInfo = new StreamConsumerFullInfo(BuilderFactory.createMapFromDecodingFunctions(consumerInfoIterator, this.mappingFunctions));
                list.add(consumerInfo);
            }
            return list;
        }

        public String toString() {
            return "List<StreamConsumerFullInfo>";
        }
    };
    private static final Builder<List<StreamGroupFullInfo>> STREAM_GROUP_FULL_INFO_LIST = new Builder<List<StreamGroupFullInfo>>(){
        final Map<String, Builder> mappingFunctions = this.createDecoderMap();

        private Map<String, Builder> createDecoderMap() {
            HashMap<String, Builder> tempMappingFunctions = new HashMap<String, Builder>();
            tempMappingFunctions.put("name", STRING);
            tempMappingFunctions.put("consumers", STREAM_CONSUMER_FULL_INFO_LIST);
            tempMappingFunctions.put("pending", ENCODED_OBJECT_LIST);
            tempMappingFunctions.put("last-delivered-id", STREAM_ENTRY_ID);
            tempMappingFunctions.put("pel-count", LONG);
            return tempMappingFunctions;
        }

        @Override
        public List<StreamGroupFullInfo> build(Object data) {
            if (null == data) {
                return null;
            }
            ArrayList<StreamGroupFullInfo> list = new ArrayList<StreamGroupFullInfo>();
            List streamsEntries = (List)data;
            for (Object streamsEntry : streamsEntries) {
                List groupInfo = (List)streamsEntry;
                Iterator groupInfoIterator = groupInfo.iterator();
                StreamGroupFullInfo groupFullInfo = new StreamGroupFullInfo(BuilderFactory.createMapFromDecodingFunctions(groupInfoIterator, this.mappingFunctions));
                list.add(groupFullInfo);
            }
            return list;
        }

        public String toString() {
            return "List<StreamGroupFullInfo>";
        }
    };
    public static final Builder<StreamFullInfo> STREAM_FULL_INFO = new Builder<StreamFullInfo>(){
        final Map<String, Builder> mappingFunctions = this.createDecoderMap();

        private Map<String, Builder> createDecoderMap() {
            HashMap<String, Builder> tempMappingFunctions = new HashMap<String, Builder>();
            tempMappingFunctions.put("last-generated-id", STREAM_ENTRY_ID);
            tempMappingFunctions.put("length", LONG);
            tempMappingFunctions.put("radix-tree-keys", LONG);
            tempMappingFunctions.put("radix-tree-nodes", LONG);
            tempMappingFunctions.put("groups", STREAM_GROUP_FULL_INFO_LIST);
            tempMappingFunctions.put("entries", STREAM_ENTRY_LIST);
            return tempMappingFunctions;
        }

        @Override
        public StreamFullInfo build(Object data) {
            if (null == data) {
                return null;
            }
            List streamsEntries = (List)data;
            Iterator iterator = streamsEntries.iterator();
            return new StreamFullInfo(BuilderFactory.createMapFromDecodingFunctions(iterator, this.mappingFunctions));
        }

        public String toString() {
            return "StreamFullInfo";
        }
    };
    @Deprecated
    public static final Builder<StreamFullInfo> STREAM_INFO_FULL = STREAM_FULL_INFO;
    public static final Builder<StreamPendingSummary> STREAM_PENDING_SUMMARY = new Builder<StreamPendingSummary>(){

        @Override
        public StreamPendingSummary build(Object data) {
            if (null == data) {
                return null;
            }
            List objectList = (List)data;
            long total = LONG.build(objectList.get(0));
            String minId = SafeEncoder.encode((byte[])objectList.get(1));
            String maxId = SafeEncoder.encode((byte[])objectList.get(2));
            List consumerObjList = (List)objectList.get(3);
            HashMap<String, Long> map = new HashMap<String, Long>(consumerObjList.size());
            for (List consumerObj : consumerObjList) {
                map.put(SafeEncoder.encode((byte[])consumerObj.get(0)), Long.parseLong(SafeEncoder.encode((byte[])consumerObj.get(1))));
            }
            return new StreamPendingSummary(total, new StreamEntryID(minId), new StreamEntryID(maxId), map);
        }

        public String toString() {
            return "StreamPendingSummary";
        }
    };
    private static final List<Builder> BACKUP_BUILDERS_FOR_DECODING_FUNCTIONS = Arrays.asList(STRING, LONG, DOUBLE);
    public static final Builder<LCSMatchResult> STR_ALGO_LCS_RESULT_BUILDER = new Builder<LCSMatchResult>(){

        @Override
        public LCSMatchResult build(Object data) {
            if (data == null) {
                return null;
            }
            if (data instanceof byte[]) {
                return new LCSMatchResult(STRING.build(data));
            }
            if (data instanceof Long) {
                return new LCSMatchResult(LONG.build(data));
            }
            long len = 0L;
            ArrayList<LCSMatchResult.MatchedPosition> matchedPositions = new ArrayList<LCSMatchResult.MatchedPosition>();
            List objectList = (List)data;
            if (objectList.get(0) instanceof KeyValue) {
                for (KeyValue kv : objectList) {
                    if ("matches".equalsIgnoreCase(STRING.build(kv.getKey()))) {
                        this.addMatchedPosition(matchedPositions, kv.getValue());
                        continue;
                    }
                    if (!"len".equalsIgnoreCase(STRING.build(kv.getKey()))) continue;
                    len = LONG.build(kv.getValue());
                }
            } else {
                for (int i = 0; i < objectList.size(); i += 2) {
                    if ("matches".equalsIgnoreCase(STRING.build(objectList.get(i)))) {
                        this.addMatchedPosition(matchedPositions, objectList.get(i + 1));
                        continue;
                    }
                    if (!"len".equalsIgnoreCase(STRING.build(objectList.get(i)))) continue;
                    len = LONG.build(objectList.get(i + 1));
                }
            }
            return new LCSMatchResult(matchedPositions, len);
        }

        private void addMatchedPosition(List<LCSMatchResult.MatchedPosition> matchedPositions, Object o) {
            List matches = (List)o;
            for (Object obj : matches) {
                if (!(obj instanceof List)) continue;
                List positions = (List)obj;
                LCSMatchResult.Position a = new LCSMatchResult.Position(LONG.build(((List)positions.get(0)).get(0)), LONG.build(((List)positions.get(0)).get(1)));
                LCSMatchResult.Position b = new LCSMatchResult.Position(LONG.build(((List)positions.get(1)).get(0)), LONG.build(((List)positions.get(1)).get(1)));
                long matchLen = 0L;
                if (positions.size() >= 3) {
                    matchLen = LONG.build(positions.get(2));
                }
                matchedPositions.add(new LCSMatchResult.MatchedPosition(a, b, matchLen));
            }
        }
    };
    public static final Builder<Map<String, String>> STRING_MAP_FROM_PAIRS = new Builder<Map<String, String>>(){

        @Override
        public Map<String, String> build(Object data) {
            List list = (List)data;
            if (list.isEmpty()) {
                return Collections.emptyMap();
            }
            if (list.get(0) instanceof KeyValue) {
                return list.stream().collect(Collectors.toMap(kv -> STRING.build(kv.getKey()), kv -> STRING.build(kv.getValue())));
            }
            HashMap<String, String> map = new HashMap<String, String>(list.size());
            for (Object object : list) {
                List flat;
                if (object == null || (flat = (List)object).isEmpty()) continue;
                map.put(STRING.build(flat.get(0)), STRING.build(flat.get(1)));
            }
            return map;
        }

        public String toString() {
            return "Map<String, String>";
        }
    };
    public static final Builder<Map<String, Object>> ENCODED_OBJECT_MAP_FROM_PAIRS = new Builder<Map<String, Object>>(){

        @Override
        public Map<String, Object> build(Object data) {
            List list = (List)data;
            if (list.isEmpty()) {
                return Collections.emptyMap();
            }
            if (list.get(0) instanceof KeyValue) {
                return list.stream().collect(Collectors.toMap(kv -> STRING.build(kv.getKey()), kv -> ENCODED_OBJECT.build(kv.getValue())));
            }
            HashMap<String, Object> map = new HashMap<String, Object>(list.size());
            for (Object object : list) {
                List flat;
                if (object == null || (flat = (List)object).isEmpty()) continue;
                map.put(STRING.build(flat.get(0)), STRING.build(flat.get(1)));
            }
            return map;
        }

        public String toString() {
            return "Map<String, String>";
        }
    };
    @Deprecated
    public static final Builder<List<LibraryInfo>> LIBRARY_LIST = LibraryInfo.LIBRARY_INFO_LIST;
    public static final Builder<List<List<String>>> STRING_LIST_LIST = new Builder<List<List<String>>>(){

        @Override
        public List<List<String>> build(Object data) {
            if (null == data) {
                return null;
            }
            return ((List)data).stream().map(STRING_LIST::build).collect(Collectors.toList());
        }

        public String toString() {
            return "List<List<String>>";
        }
    };
    public static final Builder<List<List<Object>>> ENCODED_OBJECT_LIST_LIST = new Builder<List<List<Object>>>(){

        @Override
        public List<List<Object>> build(Object data) {
            if (null == data) {
                return null;
            }
            return ((List)data).stream().map(ENCODED_OBJECT_LIST::build).collect(Collectors.toList());
        }

        public String toString() {
            return "List<List<Object>>";
        }
    };

    private static Map<String, Object> createMapFromDecodingFunctions(Iterator<Object> iterator, Map<String, Builder> mappingFunctions) {
        return BuilderFactory.createMapFromDecodingFunctions(iterator, mappingFunctions, null);
    }

    private static Map<String, Object> createMapFromDecodingFunctions(Iterator<Object> iterator, Map<String, Builder> mappingFunctions, Collection<Builder> backupBuilders) {
        if (!iterator.hasNext()) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        block2: while (iterator.hasNext()) {
            Object rawValue;
            String mapKey;
            Object tempObject = iterator.next();
            if (tempObject instanceof KeyValue) {
                KeyValue kv = (KeyValue)tempObject;
                mapKey = STRING.build(kv.getKey());
                rawValue = kv.getValue();
            } else {
                mapKey = STRING.build(tempObject);
                rawValue = iterator.next();
            }
            if (mappingFunctions.containsKey(mapKey)) {
                resultMap.put(mapKey, mappingFunctions.get(mapKey).build(rawValue));
                continue;
            }
            Collection<Builder> builders = backupBuilders != null ? backupBuilders : mappingFunctions.values();
            for (Builder b : builders) {
                try {
                    resultMap.put(mapKey, b.build(rawValue));
                    continue block2;
                }
                catch (ClassCastException classCastException) {
                }
            }
        }
        return resultMap;
    }

    private BuilderFactory() {
        throw new InstantiationError("Must not instantiate this class");
    }

    protected static class SetFromList<E>
    extends AbstractSet<E>
    implements Serializable {
        private static final long serialVersionUID = -2850347066962734052L;
        private final List<E> list;

        private SetFromList(List<E> list) {
            this.list = list;
        }

        @Override
        public void clear() {
            this.list.clear();
        }

        @Override
        public int size() {
            return this.list.size();
        }

        @Override
        public boolean isEmpty() {
            return this.list.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.list.contains(o);
        }

        @Override
        public boolean remove(Object o) {
            return this.list.remove(o);
        }

        @Override
        public boolean add(E e) {
            return !this.contains(e) && this.list.add(e);
        }

        @Override
        public Iterator<E> iterator() {
            return this.list.iterator();
        }

        @Override
        public Object[] toArray() {
            return this.list.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.list.toArray(a);
        }

        @Override
        public String toString() {
            return this.list.toString();
        }

        @Override
        public int hashCode() {
            return this.list.hashCode();
        }

        @Override
        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o == this) {
                return true;
            }
            if (!(o instanceof Set)) {
                return false;
            }
            Collection c = (Collection)o;
            if (c.size() != this.size()) {
                return false;
            }
            return this.containsAll(c);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.list.containsAll(c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.list.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.list.retainAll(c);
        }

        protected static <E> SetFromList<E> of(List<E> list) {
            if (list == null) {
                return null;
            }
            return new SetFromList<E>(list);
        }
    }
}

