/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.client.cache;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.druid.client.cache.AbstractRedisCache;
import org.apache.druid.client.cache.Cache;
import org.apache.druid.client.cache.RedisCacheConfig;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.redis.shaded.redis.clients.jedis.JedisCluster;
import org.apache.druid.redis.shaded.redis.clients.jedis.util.JedisClusterCRC16;

public class RedisClusterCache
extends AbstractRedisCache {
    private final JedisCluster cluster;

    RedisClusterCache(JedisCluster cluster, RedisCacheConfig config) {
        super(config);
        this.cluster = cluster;
    }

    @Override
    protected byte[] getFromRedis(byte[] key) {
        return this.cluster.get(key);
    }

    @Override
    protected void putToRedis(byte[] key, byte[] value, RedisCacheConfig.DurationConfig expiration) {
        this.cluster.setex(key, (long)((int)expiration.getSeconds()), value);
    }

    @Override
    protected Pair<Integer, Map<Cache.NamedKey, byte[]>> mgetFromRedis(Iterable<Cache.NamedKey> keys) {
        int inputKeyCount = 0;
        HashMap<Integer, List> slot2Keys = new HashMap<Integer, List>();
        for (Cache.NamedKey key : keys) {
            ++inputKeyCount;
            CachableKey cachableKey = new CachableKey(key);
            int keySlot = JedisClusterCRC16.getSlot(cachableKey.keyBytes);
            slot2Keys.computeIfAbsent(keySlot, val -> new ArrayList()).add(cachableKey);
        }
        ConcurrentHashMap results = new ConcurrentHashMap();
        slot2Keys.keySet().parallelStream().forEach(slot -> {
            List keyList = (List)slot2Keys.get(slot);
            List<byte[]> values = this.cluster.mget((byte[][])keyList.stream().map(key -> key.keyBytes).toArray(x$0 -> new byte[x$0][]));
            for (int i = 0; i < keyList.size(); ++i) {
                byte[] value = values.get(i);
                if (value == null) continue;
                results.put(((CachableKey)keyList.get((int)i)).namedKey, value);
            }
        });
        return new Pair((Object)inputKeyCount, results);
    }

    @Override
    protected void cleanup() {
        this.cluster.close();
    }

    static class CachableKey {
        byte[] keyBytes;
        Cache.NamedKey namedKey;

        public CachableKey(Cache.NamedKey namedKey) {
            this.keyBytes = namedKey.toByteArray();
            this.namedKey = namedKey;
        }
    }
}

