/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.redis.shaded.redis.clients.jedis.util;

import org.apache.druid.redis.shaded.redis.clients.jedis.util.SafeEncoder;

public final class JedisClusterHashTag {
    private JedisClusterHashTag() {
        throw new InstantiationError("Must not instantiate this class");
    }

    public static String getHashTag(String key) {
        return JedisClusterHashTag.extractHashTag(key, true);
    }

    public static boolean isClusterCompliantMatchPattern(byte[] matchPattern) {
        return JedisClusterHashTag.isClusterCompliantMatchPattern(SafeEncoder.encode(matchPattern));
    }

    public static boolean isClusterCompliantMatchPattern(String matchPattern) {
        String tag = JedisClusterHashTag.extractHashTag(matchPattern, false);
        return tag != null && !tag.isEmpty();
    }

    private static String extractHashTag(String key, boolean returnKeyOnAbsence) {
        int e;
        int s = key.indexOf("{");
        if (s > -1 && (e = key.indexOf("}", s + 1)) > -1 && e != s + 1) {
            return key.substring(s + 1, e);
        }
        return returnKeyOnAbsence ? key : null;
    }
}

