/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.redis.shaded.redis.clients.jedis.timeseries;

import java.util.AbstractMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.druid.redis.shaded.redis.clients.jedis.Builder;
import org.apache.druid.redis.shaded.redis.clients.jedis.BuilderFactory;
import org.apache.druid.redis.shaded.redis.clients.jedis.timeseries.AggregationType;
import org.apache.druid.redis.shaded.redis.clients.jedis.timeseries.TSElement;
import org.apache.druid.redis.shaded.redis.clients.jedis.timeseries.TSMGetElement;
import org.apache.druid.redis.shaded.redis.clients.jedis.timeseries.TSMRangeElements;
import org.apache.druid.redis.shaded.redis.clients.jedis.util.KeyValue;

public final class TimeSeriesBuilderFactory {
    public static final Builder<TSElement> TIMESERIES_ELEMENT = new Builder<TSElement>(){

        @Override
        public TSElement build(Object data) {
            List list = (List)data;
            if (list == null || list.isEmpty()) {
                return null;
            }
            return new TSElement(BuilderFactory.LONG.build(list.get(0)), BuilderFactory.DOUBLE.build(list.get(1)));
        }
    };
    public static final Builder<List<TSElement>> TIMESERIES_ELEMENT_LIST = new Builder<List<TSElement>>(){

        @Override
        public List<TSElement> build(Object data) {
            return ((List)data).stream().map(pairObject -> (List)pairObject).map(pairList -> new TSElement(BuilderFactory.LONG.build(pairList.get(0)), BuilderFactory.DOUBLE.build(pairList.get(1)))).collect(Collectors.toList());
        }
    };
    public static final Builder<Map<String, TSMRangeElements>> TIMESERIES_MRANGE_RESPONSE = new Builder<Map<String, TSMRangeElements>>(){

        @Override
        public Map<String, TSMRangeElements> build(Object data) {
            return ((List)data).stream().map(tsObject -> (List)tsObject).map(tsList -> new TSMRangeElements(BuilderFactory.STRING.build(tsList.get(0)), BuilderFactory.STRING_MAP_FROM_PAIRS.build(tsList.get(1)), TIMESERIES_ELEMENT_LIST.build(tsList.get(2)))).collect(Collectors.toMap(AbstractMap.SimpleImmutableEntry::getKey, Function.identity(), (x, y) -> x, LinkedHashMap::new));
        }
    };
    public static final Builder<Map<String, TSMRangeElements>> TIMESERIES_MRANGE_RESPONSE_RESP3 = new Builder<Map<String, TSMRangeElements>>(){

        @Override
        public Map<String, TSMRangeElements> build(Object data) {
            List dataList = (List)data;
            LinkedHashMap<String, TSMRangeElements> map = new LinkedHashMap<String, TSMRangeElements>(dataList.size() / 2, 1.0f);
            for (KeyValue kv : dataList) {
                TSMRangeElements elements;
                String key = BuilderFactory.STRING.build(kv.getKey());
                List valueList = (List)kv.getValue();
                switch (valueList.size()) {
                    case 3: {
                        List aggrMapObj = (List)valueList.get(1);
                        KeyValue aggKV = (KeyValue)aggrMapObj.get(0);
                        assert ("aggregators".equalsIgnoreCase(BuilderFactory.STRING.build(aggKV.getKey())));
                        elements = new TSMRangeElements(key, BuilderFactory.STRING_MAP.build(valueList.get(0)), ((List)aggKV.getValue()).stream().map(BuilderFactory.STRING::build).map(AggregationType::safeValueOf).collect(Collectors.toList()), TIMESERIES_ELEMENT_LIST.build(valueList.get(2)));
                        break;
                    }
                    case 4: {
                        List rdcMapObj = (List)valueList.get(1);
                        assert ("reducers".equalsIgnoreCase(BuilderFactory.STRING.build(((KeyValue)rdcMapObj.get(0)).getKey())));
                        List srcMapObj = (List)valueList.get(2);
                        assert ("sources".equalsIgnoreCase(BuilderFactory.STRING.build(((KeyValue)srcMapObj.get(0)).getKey())));
                        elements = new TSMRangeElements(key, BuilderFactory.STRING_MAP.build(valueList.get(0)), BuilderFactory.STRING_LIST.build(((KeyValue)rdcMapObj.get(0)).getValue()), BuilderFactory.STRING_LIST.build(((KeyValue)srcMapObj.get(0)).getValue()), TIMESERIES_ELEMENT_LIST.build(valueList.get(3)));
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                map.put(key, elements);
            }
            return map;
        }
    };
    public static final Builder<Map<String, TSMGetElement>> TIMESERIES_MGET_RESPONSE = new Builder<Map<String, TSMGetElement>>(){

        @Override
        public Map<String, TSMGetElement> build(Object data) {
            return ((List)data).stream().map(tsObject -> (List)tsObject).map(tsList -> new TSMGetElement(BuilderFactory.STRING.build(tsList.get(0)), BuilderFactory.STRING_MAP_FROM_PAIRS.build(tsList.get(1)), TIMESERIES_ELEMENT.build(tsList.get(2)))).collect(Collectors.toMap(AbstractMap.SimpleImmutableEntry::getKey, Function.identity()));
        }
    };
    public static final Builder<Map<String, TSMGetElement>> TIMESERIES_MGET_RESPONSE_RESP3 = new Builder<Map<String, TSMGetElement>>(){

        @Override
        public Map<String, TSMGetElement> build(Object data) {
            List dataList = (List)data;
            LinkedHashMap<String, TSMGetElement> map = new LinkedHashMap<String, TSMGetElement>(dataList.size());
            for (KeyValue kv : dataList) {
                String key = BuilderFactory.STRING.build(kv.getKey());
                List valueList = (List)kv.getValue();
                TSMGetElement value = new TSMGetElement(key, BuilderFactory.STRING_MAP.build(valueList.get(0)), TIMESERIES_ELEMENT.build(valueList.get(1)));
                map.put(key, value);
            }
            return map;
        }
    };

    private TimeSeriesBuilderFactory() {
        throw new InstantiationError("Must not instantiate this class");
    }
}

