/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.redis.shaded.redis.clients.jedis.search;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.druid.redis.shaded.redis.clients.jedis.Builder;
import org.apache.druid.redis.shaded.redis.clients.jedis.BuilderFactory;
import org.apache.druid.redis.shaded.redis.clients.jedis.util.KeyValue;
import org.apache.druid.redis.shaded.redis.clients.jedis.util.SafeEncoder;

public class Document
implements Serializable {
    private static final long serialVersionUID = 4884173545291367373L;
    private final String id;
    private Double score;
    private final Map<String, Object> fields;
    static Builder<Document> SEARCH_DOCUMENT = new Builder<Document>(){
        private static final String ID_STR = "id";
        private static final String SCORE_STR = "score";
        private static final String FIELDS_STR = "extra_attributes";

        @Override
        public Document build(Object data) {
            List list = (List)data;
            String id = null;
            Double score = null;
            Map<String, Object> fields = null;
            for (KeyValue kv : list) {
                String key;
                switch (key = BuilderFactory.STRING.build(kv.getKey())) {
                    case "id": {
                        id = BuilderFactory.STRING.build(kv.getValue());
                        break;
                    }
                    case "score": {
                        score = BuilderFactory.DOUBLE.build(kv.getValue());
                        break;
                    }
                    case "extra_attributes": {
                        fields = BuilderFactory.ENCODED_OBJECT_MAP.build(kv.getValue());
                    }
                }
            }
            return new Document(id, score, fields);
        }
    };

    public Document(String id) {
        this(id, 1.0);
    }

    public Document(String id, double score) {
        this(id, new HashMap<String, Object>(), score);
    }

    public Document(String id, Map<String, Object> fields) {
        this(id, fields, 1.0);
    }

    public Document(String id, Map<String, Object> fields, double score) {
        this.id = id;
        this.fields = fields;
        this.score = score;
    }

    private Document(String id, Double score, Map<String, Object> fields) {
        this.id = id;
        this.score = score;
        this.fields = fields;
    }

    public Iterable<Map.Entry<String, Object>> getProperties() {
        return this.fields.entrySet();
    }

    public static Document load(String id, double score, byte[] payload, List<byte[]> fields) {
        return Document.load(id, score, fields, true);
    }

    public static Document load(String id, double score, List<byte[]> fields, boolean decode) {
        Document ret = new Document(id, score);
        if (fields != null) {
            for (int i = 0; i < fields.size(); i += 2) {
                byte[] rawKey = fields.get(i);
                byte[] rawValue = fields.get(i + 1);
                String key = SafeEncoder.encode(rawKey);
                byte[] value = rawValue == null ? null : (decode ? (Object)SafeEncoder.encode(rawValue) : rawValue);
                ret.set(key, value);
            }
        }
        return ret;
    }

    public String getId() {
        return this.id;
    }

    public Double getScore() {
        return this.score;
    }

    public Object get(String key) {
        return this.fields.get(key);
    }

    public String getString(String key) {
        Object value = this.fields.get(key);
        if (value instanceof String) {
            return (String)value;
        }
        return value instanceof byte[] ? SafeEncoder.encode((byte[])value) : value.toString();
    }

    public boolean hasProperty(String key) {
        return this.fields.containsKey(key);
    }

    public Document set(String key, Object value) {
        this.fields.put(key, value);
        return this;
    }

    public Document setScore(float score) {
        this.score = score;
        return this;
    }

    public String toString() {
        return "id:" + this.getId() + ", score: " + this.getScore() + ", properties:" + this.getProperties();
    }
}

