/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.client.cache;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.metadata.PasswordProvider;
import org.joda.time.Period;

public class RedisCacheConfig {
    @JsonProperty
    private String host;
    @JsonProperty
    @Min(value=0L)
    @Max(value=65535L)
    private @Min(value=0L) @Max(value=65535L) int port;
    @JsonProperty
    private DurationConfig expiration = new DurationConfig("P1D");
    @JsonProperty
    private DurationConfig timeout = new DurationConfig("PT2S");
    @JsonProperty
    private int maxTotalConnections = 8;
    @JsonProperty
    private int maxIdleConnections = 8;
    @JsonProperty
    private int minIdleConnections = 0;
    @JsonProperty
    private PasswordProvider password;
    @JsonProperty
    @Min(value=0L)
    private @Min(value=0L) int database = 0;
    @JsonProperty
    private RedisClusterConfig cluster;

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public DurationConfig getExpiration() {
        return this.expiration;
    }

    public DurationConfig getTimeout() {
        return this.timeout;
    }

    public int getMaxTotalConnections() {
        return this.maxTotalConnections;
    }

    public int getMaxIdleConnections() {
        return this.maxIdleConnections;
    }

    public int getMinIdleConnections() {
        return this.minIdleConnections;
    }

    public RedisClusterConfig getCluster() {
        return this.cluster;
    }

    public PasswordProvider getPassword() {
        return this.password;
    }

    public int getDatabase() {
        return this.database;
    }

    public static class DurationConfig {
        private long milliseconds;

        public DurationConfig(String time) {
            try {
                this.milliseconds = Long.parseLong(time);
            }
            catch (NumberFormatException e) {
                this.milliseconds = Period.parse((String)time).toStandardDuration().getMillis();
            }
        }

        @VisibleForTesting
        DurationConfig(long milliseconds) {
            this.milliseconds = milliseconds;
        }

        public long getMilliseconds() {
            return this.milliseconds;
        }

        public int getMillisecondsAsInt() {
            if (this.milliseconds > Integer.MAX_VALUE) {
                throw new ISE("Milliseconds %d is out of range of int", new Object[]{this.milliseconds});
            }
            return (int)this.milliseconds;
        }

        public long getSeconds() {
            return this.milliseconds / 1000L;
        }
    }

    public static class RedisClusterConfig {
        @JsonProperty
        private String nodes;
        @JsonProperty
        private int maxRedirection = 5;

        public String getNodes() {
            return this.nodes;
        }

        public int getMaxRedirection() {
            return this.maxRedirection;
        }
    }
}

