/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.movingaverage.averagers;

import org.apache.druid.query.movingaverage.averagers.BaseAverager;

public class LongMeanAverager
extends BaseAverager<Number, Double> {
    public LongMeanAverager(int numBuckets, String name, String fieldName, int cycleSize) {
        super(Number.class, numBuckets, name, fieldName, cycleSize);
    }

    @Override
    protected Double computeResult() {
        long result = 0L;
        int validBuckets = 0;
        for (int i = 0; i < this.numBuckets; i += this.cycleSize) {
            result = ((Number[])this.buckets)[(i + this.startFrom) % this.numBuckets] != null ? (result += ((Number[])this.buckets)[(i + this.startFrom) % this.numBuckets].longValue()) : (result += 0L);
            ++validBuckets;
        }
        ++this.startFrom;
        return (double)result / (double)validBuckets;
    }
}

