/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.movingaverage.averagers;

import org.apache.druid.query.movingaverage.averagers.BaseAverager;

public class DoubleMeanAverager
extends BaseAverager<Number, Double> {
    public DoubleMeanAverager(int numBuckets, String name, String fieldName, int cycleSize) {
        super(Number.class, numBuckets, name, fieldName, cycleSize);
    }

    @Override
    protected Double computeResult() {
        double result = 0.0;
        int validBuckets = 0;
        for (int i = 0; i < this.numBuckets; i += this.cycleSize) {
            result = ((Number[])this.buckets)[(i + this.startFrom) % this.numBuckets] != null ? (result += ((Number[])this.buckets)[(i + this.startFrom) % this.numBuckets].doubleValue()) : (result += 0.0);
            ++validBuckets;
        }
        ++this.startFrom;
        return result / (double)validBuckets;
    }
}

