/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.movingaverage.averagers;

import org.apache.druid.query.movingaverage.averagers.BaseAverager;

public class DoubleMaxAverager
extends BaseAverager<Number, Double> {
    public DoubleMaxAverager(int numBuckets, String name, String fieldName, int cycleSize) {
        super(Number.class, numBuckets, name, fieldName, cycleSize);
    }

    @Override
    protected Double computeResult() {
        double result = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.numBuckets; i += this.cycleSize) {
            if (((Number[])this.buckets)[(i + this.startFrom) % this.numBuckets] == null) continue;
            result = Double.max(result, ((Number[])this.buckets)[(i + this.startFrom) % this.numBuckets].doubleValue());
        }
        ++this.startFrom;
        return result;
    }
}

