/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.movingaverage.averagers;

import java.lang.reflect.Array;
import java.util.Map;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.movingaverage.averagers.Averager;

public abstract class BaseAverager<I, R>
implements Averager<R> {
    final int numBuckets;
    final int cycleSize;
    private final String name;
    private final String fieldName;
    final I[] buckets;
    private int index;
    int startFrom = 0;

    public BaseAverager(Class<I> storageType, int numBuckets, String name, String fieldName, int cycleSize) {
        this.numBuckets = numBuckets;
        this.name = name;
        this.fieldName = fieldName;
        this.index = 0;
        Object[] array = (Object[])Array.newInstance(storageType, numBuckets);
        this.buckets = array;
        this.cycleSize = cycleSize;
    }

    @Override
    public void addElement(Map<String, Object> e, Map<String, AggregatorFactory> a) {
        Object finalMetric;
        Object metric = e.get(this.fieldName);
        if (a.containsKey(this.fieldName)) {
            AggregatorFactory af = a.get(this.fieldName);
            finalMetric = metric != null ? af.finalizeComputation(metric) : null;
        } else {
            finalMetric = metric;
        }
        this.buckets[this.index++] = finalMetric;
        this.index %= this.numBuckets;
    }

    @Override
    public void skip() {
        this.buckets[this.index++] = null;
        this.index %= this.numBuckets;
    }

    @Override
    public R getResult() {
        if (!this.hasData()) {
            return null;
        }
        return this.computeResult();
    }

    protected abstract R computeResult();

    @Override
    public String getName() {
        return this.name;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public int getNumBuckets() {
        return this.numBuckets;
    }

    public int getCycleSize() {
        return this.cycleSize;
    }

    protected I[] getBuckets() {
        return this.buckets;
    }

    protected boolean hasData() {
        for (I b : this.buckets) {
            if (b == null) continue;
            return true;
        }
        return false;
    }
}

