/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.movingaverage.averagers;

import org.apache.druid.query.movingaverage.averagers.BaseAverager;

public class LongMinAverager
extends BaseAverager<Number, Long> {
    public LongMinAverager(int numBuckets, String name, String fieldName, int cycleSize) {
        super(Number.class, numBuckets, name, fieldName, cycleSize);
    }

    @Override
    protected Long computeResult() {
        long result = Long.MAX_VALUE;
        for (int i = 0; i < this.numBuckets; i += this.cycleSize) {
            if (((Number[])this.buckets)[(i + this.startFrom) % this.numBuckets] == null) continue;
            result = Long.min(result, ((Number[])this.buckets)[(i + this.startFrom) % this.numBuckets].longValue());
        }
        ++this.startFrom;
        return result;
    }
}

