/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.movingaverage.averagers;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.druid.query.movingaverage.averagers.Averager;
import org.apache.druid.query.movingaverage.averagers.AveragerFactory;
import org.apache.druid.query.movingaverage.averagers.ConstantAverager;

public class ConstantAveragerFactory
implements AveragerFactory<Float, Float> {
    private String name;
    private int numBuckets;
    private float retval;

    @JsonCreator
    public ConstantAveragerFactory(@JsonProperty(value="name") String name, @JsonProperty(value="buckets") int numBuckets, @JsonProperty(value="retval") float retval) {
        this.name = name;
        this.numBuckets = numBuckets;
        this.retval = retval;
    }

    @Override
    @JsonProperty
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="buckets")
    public int getNumBuckets() {
        return this.numBuckets;
    }

    @JsonProperty
    public float getRetval() {
        return this.retval;
    }

    @Override
    public Averager<Float> createAverager() {
        return new ConstantAverager(this.numBuckets, this.name, this.retval);
    }

    @Override
    public List<String> getDependentFields() {
        return Collections.emptyList();
    }

    @Override
    public Comparator<Float> getComparator() {
        return Comparator.naturalOrder();
    }

    @Override
    public int getCycleSize() {
        return 1;
    }

    @Override
    public Float finalizeComputation(Float val) {
        return val;
    }
}

