/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.iceberg.input;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.error.InvalidInput;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.iceberg.guice.HiveConf;
import org.apache.druid.iceberg.input.IcebergCatalog;
import org.apache.druid.utils.DynamicConfigProviderUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.catalog.SessionCatalog;
import org.apache.iceberg.rest.HTTPClient;
import org.apache.iceberg.rest.RESTCatalog;

public class RestIcebergCatalog
extends IcebergCatalog {
    public static final String TYPE_KEY = "rest";
    @JsonProperty
    private final String catalogUri;
    @JsonProperty
    private final Map<String, String> catalogProperties;
    private final Configuration configuration;
    private Catalog restCatalog;

    @JsonCreator
    public RestIcebergCatalog(@JsonProperty(value="catalogUri") String catalogUri, @JsonProperty(value="catalogProperties") @Nullable Map<String, Object> catalogProperties, @JacksonInject @Json ObjectMapper mapper, @JacksonInject @HiveConf Configuration configuration) {
        if (catalogUri == null) {
            throw InvalidInput.exception((String)"catalogUri cannot be null", (Object[])new Object[0]);
        }
        this.catalogUri = catalogUri;
        this.catalogProperties = DynamicConfigProviderUtils.extraConfigAndSetStringMap(catalogProperties, (String)"druid.dynamic.config.provider", (ObjectMapper)mapper);
        this.configuration = configuration;
    }

    @Override
    public Catalog retrieveCatalog() {
        if (this.restCatalog == null) {
            this.restCatalog = this.setupCatalog();
        }
        return this.restCatalog;
    }

    public String getCatalogUri() {
        return this.catalogUri;
    }

    public Map<String, String> getCatalogProperties() {
        return this.catalogProperties;
    }

    private RESTCatalog setupCatalog() {
        RESTCatalog restCatalog = new RESTCatalog(SessionCatalog.SessionContext.createEmpty(), config -> HTTPClient.builder((Map)config).uri((String)config.get("uri")).build());
        restCatalog.setConf((Object)this.configuration);
        this.catalogProperties.put("uri", this.catalogUri);
        restCatalog.initialize(TYPE_KEY, this.catalogProperties);
        return restCatalog;
    }
}

