/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.iceberg.input;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.iceberg.input.IcebergCatalog;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.hadoop.HadoopCatalog;

public class LocalCatalog
extends IcebergCatalog {
    public static final String TYPE_KEY = "local";
    @JsonProperty
    private final String warehousePath;
    @JsonProperty
    private final Map<String, String> catalogProperties;
    @JsonProperty
    private final Boolean caseSensitive;
    private Catalog catalog;

    @JsonCreator
    public LocalCatalog(@JsonProperty(value="warehousePath") String warehousePath, @JsonProperty(value="catalogProperties") @Nullable Map<String, String> catalogProperties, @JsonProperty(value="caseSensitive") Boolean caseSensitive) {
        Preconditions.checkNotNull((Object)warehousePath, (Object)"warehousePath is null");
        this.warehousePath = warehousePath;
        this.catalogProperties = catalogProperties;
        this.caseSensitive = caseSensitive == null ? true : caseSensitive;
        this.catalog = this.retrieveCatalog();
    }

    @JsonProperty
    public String getWarehousePath() {
        return this.warehousePath;
    }

    @JsonProperty
    public Map<String, String> getCatalogProperties() {
        return this.catalogProperties;
    }

    @Override
    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    @Override
    public Catalog retrieveCatalog() {
        if (this.catalog == null) {
            this.catalog = this.setupCatalog();
        }
        return this.catalog;
    }

    private HadoopCatalog setupCatalog() {
        HadoopCatalog hadoopCatalog = new HadoopCatalog();
        hadoopCatalog.setConf(new Configuration());
        this.catalogProperties.put("warehouse", this.warehousePath);
        hadoopCatalog.initialize("hadoop", this.catalogProperties);
        return hadoopCatalog;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocalCatalog that = (LocalCatalog)o;
        return this.warehousePath.equals(that.warehousePath) && Objects.equals(this.catalogProperties, that.catalogProperties) && Objects.equals(this.caseSensitive, that.caseSensitive);
    }

    public int hashCode() {
        return Objects.hash(this.warehousePath, this.catalogProperties, this.caseSensitive);
    }
}

