/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.iceberg.input;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.InputRowListPlusRawValues;
import org.apache.druid.data.input.InputRowSchema;
import org.apache.druid.data.input.InputSource;
import org.apache.druid.data.input.InputSourceFactory;
import org.apache.druid.data.input.InputSourceReader;
import org.apache.druid.data.input.InputSplit;
import org.apache.druid.data.input.InputStats;
import org.apache.druid.data.input.SplitHintSpec;
import org.apache.druid.data.input.impl.SplittableInputSource;
import org.apache.druid.iceberg.filter.IcebergFilter;
import org.apache.druid.iceberg.input.IcebergCatalog;
import org.apache.druid.java.util.common.CloseableIterators;
import org.apache.druid.java.util.common.parsers.CloseableIterator;
import org.joda.time.DateTime;

public class IcebergInputSource
implements SplittableInputSource<List<String>> {
    public static final String TYPE_KEY = "iceberg";
    @JsonProperty
    private final String tableName;
    @JsonProperty
    private final String namespace;
    @JsonProperty
    private IcebergCatalog icebergCatalog;
    @JsonProperty
    private IcebergFilter icebergFilter;
    @JsonProperty
    private InputSourceFactory warehouseSource;
    @JsonProperty
    private final DateTime snapshotTime;
    private boolean isLoaded = false;
    private SplittableInputSource delegateInputSource;

    @JsonCreator
    public IcebergInputSource(@JsonProperty(value="tableName") String tableName, @JsonProperty(value="namespace") String namespace, @JsonProperty(value="icebergFilter") @Nullable IcebergFilter icebergFilter, @JsonProperty(value="icebergCatalog") IcebergCatalog icebergCatalog, @JsonProperty(value="warehouseSource") InputSourceFactory warehouseSource, @JsonProperty(value="snapshotTime") @Nullable DateTime snapshotTime) {
        this.tableName = (String)Preconditions.checkNotNull((Object)tableName, (Object)"tableName cannot be null");
        this.namespace = (String)Preconditions.checkNotNull((Object)namespace, (Object)"namespace cannot be null");
        this.icebergCatalog = (IcebergCatalog)Preconditions.checkNotNull((Object)icebergCatalog, (Object)"icebergCatalog cannot be null");
        this.icebergFilter = icebergFilter;
        this.warehouseSource = (InputSourceFactory)Preconditions.checkNotNull((Object)warehouseSource, (Object)"warehouseSource cannot be null");
        this.snapshotTime = snapshotTime;
    }

    public boolean needsFormat() {
        return true;
    }

    public InputSourceReader reader(InputRowSchema inputRowSchema, @Nullable InputFormat inputFormat, File temporaryDirectory) {
        if (!this.isLoaded) {
            this.retrieveIcebergDatafiles();
        }
        return this.getDelegateInputSource().reader(inputRowSchema, inputFormat, temporaryDirectory);
    }

    public Stream<InputSplit<List<String>>> createSplits(InputFormat inputFormat, @Nullable SplitHintSpec splitHintSpec) throws IOException {
        if (!this.isLoaded) {
            this.retrieveIcebergDatafiles();
        }
        return this.getDelegateInputSource().createSplits(inputFormat, splitHintSpec);
    }

    public int estimateNumSplits(InputFormat inputFormat, @Nullable SplitHintSpec splitHintSpec) throws IOException {
        if (!this.isLoaded) {
            this.retrieveIcebergDatafiles();
        }
        return this.getDelegateInputSource().estimateNumSplits(inputFormat, splitHintSpec);
    }

    public InputSource withSplit(InputSplit<List<String>> inputSplit) {
        return this.getDelegateInputSource().withSplit(inputSplit);
    }

    public SplitHintSpec getSplitHintSpecOrDefault(@Nullable SplitHintSpec splitHintSpec) {
        return this.getDelegateInputSource().getSplitHintSpecOrDefault(splitHintSpec);
    }

    @JsonProperty
    public String getTableName() {
        return this.tableName;
    }

    @JsonProperty
    public String getNamespace() {
        return this.namespace;
    }

    @JsonProperty
    public IcebergCatalog getIcebergCatalog() {
        return this.icebergCatalog;
    }

    @JsonProperty
    public IcebergFilter getIcebergFilter() {
        return this.icebergFilter;
    }

    @Nullable
    @JsonProperty
    public DateTime getSnapshotTime() {
        return this.snapshotTime;
    }

    public SplittableInputSource getDelegateInputSource() {
        return this.delegateInputSource;
    }

    protected void retrieveIcebergDatafiles() {
        List<String> snapshotDataFiles = this.icebergCatalog.extractSnapshotDataFiles(this.getNamespace(), this.getTableName(), this.getIcebergFilter(), this.getSnapshotTime());
        this.delegateInputSource = snapshotDataFiles.isEmpty() ? new EmptyInputSource() : this.warehouseSource.create(snapshotDataFiles);
        this.isLoaded = true;
    }

    private static class EmptyInputSource
    implements SplittableInputSource {
        private EmptyInputSource() {
        }

        public boolean needsFormat() {
            return false;
        }

        public boolean isSplittable() {
            return false;
        }

        public InputSourceReader reader(InputRowSchema inputRowSchema, @Nullable InputFormat inputFormat, File temporaryDirectory) {
            return new InputSourceReader(){

                public CloseableIterator<InputRow> read(InputStats inputStats) {
                    return CloseableIterators.wrap(Collections.emptyIterator(), () -> {});
                }

                public CloseableIterator<InputRowListPlusRawValues> sample() {
                    return CloseableIterators.wrap(Collections.emptyIterator(), () -> {});
                }
            };
        }

        public Stream<InputSplit> createSplits(InputFormat inputFormat, @Nullable SplitHintSpec splitHintSpec) {
            return Stream.empty();
        }

        public int estimateNumSplits(InputFormat inputFormat, @Nullable SplitHintSpec splitHintSpec) {
            return 0;
        }

        public InputSource withSplit(InputSplit split) {
            return null;
        }
    }
}

