/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.iceberg.input;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.ArrayList;
import java.util.List;
import org.apache.druid.iceberg.filter.IcebergFilter;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.iceberg.ContentScanTask;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.io.CloseableIterable;
import org.joda.time.DateTime;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
public abstract class IcebergCatalog {
    public static final String DRUID_DYNAMIC_CONFIG_PROVIDER_KEY = "druid.dynamic.config.provider";
    private static final Logger log = new Logger(IcebergCatalog.class);

    public abstract Catalog retrieveCatalog();

    public boolean isCaseSensitive() {
        return true;
    }

    public List<String> extractSnapshotDataFiles(String tableNamespace, String tableName, IcebergFilter icebergFilter, DateTime snapshotTime) {
        Catalog catalog = this.retrieveCatalog();
        Namespace namespace = Namespace.of((String[])new String[]{tableNamespace});
        String tableIdentifier = tableNamespace + "." + tableName;
        ArrayList<String> dataFilePaths = new ArrayList<String>();
        ClassLoader currCtxClassloader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            TableIdentifier icebergTableIdentifier = catalog.listTables(namespace).stream().filter(tableId -> tableId.toString().equals(tableIdentifier)).findFirst().orElseThrow(() -> new IAE(" Couldn't retrieve table identifier for '%s'. Please verify that the table exists in the given catalog", new Object[]{tableIdentifier}));
            long start = System.currentTimeMillis();
            TableScan tableScan = catalog.loadTable(icebergTableIdentifier).newScan();
            if (icebergFilter != null) {
                tableScan = icebergFilter.filter(tableScan);
            }
            if (snapshotTime != null) {
                tableScan = tableScan.asOfTime(snapshotTime.getMillis());
            }
            tableScan = (TableScan)tableScan.caseSensitive(this.isCaseSensitive());
            CloseableIterable tasks = tableScan.planFiles();
            CloseableIterable.transform((CloseableIterable)tasks, ContentScanTask::file).forEach(dataFile -> dataFilePaths.add(dataFile.path().toString()));
            long duration = System.currentTimeMillis() - start;
            log.info("Data file scan and fetch took [%d ms] time for [%d] paths", new Object[]{duration, dataFilePaths.size()});
        }
        catch (Exception e) {
            throw new RE((Throwable)e, "Failed to load iceberg table with identifier [%s]", new Object[]{tableIdentifier});
        }
        finally {
            Thread.currentThread().setContextClassLoader(currCtxClassloader);
        }
        return dataFilePaths;
    }
}

