/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.iceberg.input;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.IOException;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.iceberg.guice.HiveConf;
import org.apache.druid.iceberg.input.IcebergCatalog;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.utils.DynamicConfigProviderUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.hive.HiveCatalog;

public class HiveIcebergCatalog
extends IcebergCatalog {
    public static final String TYPE_KEY = "hive";
    @JsonProperty
    private String warehousePath;
    @JsonProperty
    private String catalogUri;
    @JsonProperty
    private Map<String, String> catalogProperties;
    @JsonProperty
    private final Boolean caseSensitive;
    private final Configuration configuration;
    private Catalog hiveCatalog;
    private static final Logger log = new Logger(HiveIcebergCatalog.class);

    @JsonCreator
    public HiveIcebergCatalog(@JsonProperty(value="warehousePath") String warehousePath, @JsonProperty(value="catalogUri") String catalogUri, @JsonProperty(value="catalogProperties") @Nullable Map<String, Object> catalogProperties, @JsonProperty(value="caseSensitive") Boolean caseSensitive, @JacksonInject @Json ObjectMapper mapper, @JacksonInject @HiveConf Configuration configuration) {
        this.warehousePath = (String)Preconditions.checkNotNull((Object)warehousePath, (Object)"warehousePath cannot be null");
        this.catalogUri = (String)Preconditions.checkNotNull((Object)catalogUri, (Object)"catalogUri cannot be null");
        this.catalogProperties = DynamicConfigProviderUtils.extraConfigAndSetStringMap(catalogProperties, (String)"druid.dynamic.config.provider", (ObjectMapper)mapper);
        this.caseSensitive = caseSensitive == null ? true : caseSensitive;
        this.configuration = configuration;
        this.catalogProperties.forEach((arg_0, arg_1) -> ((Configuration)this.configuration).set(arg_0, arg_1));
        this.hiveCatalog = this.retrieveCatalog();
    }

    @Override
    public Catalog retrieveCatalog() {
        if (this.hiveCatalog == null) {
            this.hiveCatalog = this.setupCatalog();
        }
        return this.hiveCatalog;
    }

    private HiveCatalog setupCatalog() {
        HiveCatalog catalog = new HiveCatalog();
        this.authenticate();
        catalog.setConf(this.configuration);
        this.catalogProperties.put("warehouse", this.warehousePath);
        this.catalogProperties.put("uri", this.catalogUri);
        catalog.initialize(TYPE_KEY, this.catalogProperties);
        return catalog;
    }

    private void authenticate() {
        String principal = this.catalogProperties.getOrDefault("principal", null);
        String keytab = this.catalogProperties.getOrDefault("keytab", null);
        if (!Strings.isNullOrEmpty((String)principal) && !Strings.isNullOrEmpty((String)keytab)) {
            UserGroupInformation.setConfiguration((Configuration)this.configuration);
            if (UserGroupInformation.isSecurityEnabled()) {
                try {
                    if (!UserGroupInformation.getCurrentUser().hasKerberosCredentials() || !UserGroupInformation.getCurrentUser().getUserName().equals(principal)) {
                        log.info("Hive trying to authenticate user [%s] with keytab [%s]..", new Object[]{principal, keytab});
                        UserGroupInformation.loginUserFromKeytab((String)principal, (String)keytab);
                    }
                }
                catch (IOException e) {
                    throw new ISE((Throwable)e, "Failed to authenticate user principal [%s] with keytab [%s]", new Object[]{principal, keytab});
                }
            }
        }
    }

    public String getWarehousePath() {
        return this.warehousePath;
    }

    public String getCatalogUri() {
        return this.catalogUri;
    }

    public Map<String, String> getCatalogProperties() {
        return this.catalogProperties;
    }

    @Override
    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }
}

