/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.iceberg.input;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.iceberg.input.IcebergCatalog;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.utils.DynamicConfigProviderUtils;
import org.apache.iceberg.aws.glue.GlueCatalog;
import org.apache.iceberg.catalog.Catalog;

public class GlueIcebergCatalog
extends IcebergCatalog {
    private static final String CATALOG_NAME = "glue";
    private Catalog catalog;
    public static final String TYPE_KEY = "glue";
    @JsonProperty
    private Map<String, String> catalogProperties;
    @JsonProperty
    private final Boolean caseSensitive;
    private static final Logger log = new Logger(GlueIcebergCatalog.class);

    @JsonCreator
    public GlueIcebergCatalog(@JsonProperty(value="catalogProperties") @Nullable Map<String, Object> catalogProperties, @JsonProperty(value="caseSensitive") Boolean caseSensitive, @JacksonInject @Json ObjectMapper mapper) {
        this.catalogProperties = DynamicConfigProviderUtils.extraConfigAndSetStringMap(catalogProperties, (String)"druid.dynamic.config.provider", (ObjectMapper)mapper);
        this.caseSensitive = caseSensitive == null ? true : caseSensitive;
        this.catalog = this.retrieveCatalog();
    }

    @Override
    public Catalog retrieveCatalog() {
        if (this.catalog == null) {
            log.info("catalog is null, setting up default glue catalog.", new Object[0]);
            this.catalog = this.setupGlueCatalog();
        }
        log.info("Glue catalog set [%s].", new Object[]{this.catalog.toString()});
        return this.catalog;
    }

    private Catalog setupGlueCatalog() {
        this.catalogProperties.put("type", "glue");
        ClassLoader currCtxClassloader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            this.catalog = new GlueCatalog();
            this.catalog.initialize("glue", this.catalogProperties);
        }
        catch (Exception e) {
            throw new RE((Throwable)e, "Failed to initialize Glue catalog", new Object[0]);
        }
        finally {
            Thread.currentThread().setContextClassLoader(currCtxClassloader);
        }
        return this.catalog;
    }

    @Override
    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }
}

