/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.iceberg.filter;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import org.apache.druid.common.config.Configs;
import org.apache.druid.iceberg.filter.IcebergFilter;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.Literal;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.Period;

public class IcebergTimeWindowFilter
implements IcebergFilter {
    @JsonProperty
    private final String filterColumn;
    @JsonProperty
    private final Duration lookbackDuration;
    @JsonProperty
    private final Duration lookaheadDuration;
    @JsonProperty
    private final DateTime baseTime;

    @JsonCreator
    public IcebergTimeWindowFilter(@JsonProperty(value="filterColumn") String filterColumn, @JsonProperty(value="lookbackDuration") Duration lookbackDuration, @JsonProperty(value="lookaheadDuration") Duration lookaheadDuration, @JsonProperty(value="baseTime") DateTime baseTime) {
        Preconditions.checkNotNull((Object)filterColumn, (Object)"You must specify a filter column on the timeWindow filter");
        this.filterColumn = filterColumn;
        this.lookbackDuration = (Duration)Configs.valueOrDefault((Object)lookbackDuration, (Object)new Period((Object)"P1D").toStandardDuration());
        this.lookaheadDuration = (Duration)Configs.valueOrDefault((Object)lookaheadDuration, (Object)Duration.ZERO);
        this.baseTime = (DateTime)Configs.valueOrDefault((Object)baseTime, (Object)DateTimes.nowUtc());
    }

    @Override
    public TableScan filter(TableScan tableScan) {
        return (TableScan)tableScan.filter(this.getFilterExpression());
    }

    @Override
    public Expression getFilterExpression() {
        long lookbackDurationinMicros = (this.baseTime.getMillis() - this.lookbackDuration.getMillis()) * 1000L;
        long lookforwardDurationinMicros = (this.baseTime.getMillis() + this.lookaheadDuration.getMillis()) * 1000L;
        return Expressions.and((Expression)Expressions.greaterThanOrEqual((String)this.filterColumn, (Object)Literal.of((long)lookbackDurationinMicros).to((Type)Types.TimestampType.withZone()).value()), (Expression)Expressions.lessThanOrEqual((String)this.filterColumn, (Object)Literal.of((long)lookforwardDurationinMicros).to((Type)Types.TimestampType.withZone()).value()));
    }
}

