/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.iceberg.filter;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import javax.annotation.Nullable;
import org.apache.druid.iceberg.filter.IcebergFilter;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.UnboundPredicate;

public class IcebergRangeFilter
implements IcebergFilter {
    @JsonProperty
    private final String filterColumn;
    @JsonProperty
    private final Boolean lowerOpen;
    @JsonProperty
    private final Boolean upperOpen;
    @JsonProperty
    private final Object lower;
    @JsonProperty
    private final Object upper;

    @JsonCreator
    public IcebergRangeFilter(@JsonProperty(value="filterColumn") String filterColumn, @JsonProperty(value="lower") @Nullable Object lower, @JsonProperty(value="upper") @Nullable Object upper, @JsonProperty(value="lowerOpen") @Nullable Boolean lowerOpen, @JsonProperty(value="upperOpen") @Nullable Boolean upperOpen) {
        Preconditions.checkNotNull((Object)filterColumn, (Object)"You must specify a filter column on the range filter");
        Preconditions.checkArgument((lower != null || upper != null ? 1 : 0) != 0, (Object)"Both lower and upper bounds cannot be empty");
        this.filterColumn = filterColumn;
        this.lowerOpen = lowerOpen != null ? lowerOpen : false;
        this.upperOpen = upperOpen != null ? upperOpen : false;
        this.lower = lower;
        this.upper = upper;
    }

    @Override
    public TableScan filter(TableScan tableScan) {
        return (TableScan)tableScan.filter(this.getFilterExpression());
    }

    @Override
    public Expression getFilterExpression() {
        ArrayList<UnboundPredicate> expressions = new ArrayList<UnboundPredicate>();
        if (this.lower != null) {
            UnboundPredicate lowerExp = this.lowerOpen != false ? Expressions.greaterThan((String)this.filterColumn, (Object)this.lower) : Expressions.greaterThanOrEqual((String)this.filterColumn, (Object)this.lower);
            expressions.add(lowerExp);
        }
        if (this.upper != null) {
            UnboundPredicate upperExp = this.upperOpen != false ? Expressions.lessThan((String)this.filterColumn, (Object)this.upper) : Expressions.lessThanOrEqual((String)this.filterColumn, (Object)this.upper);
            expressions.add(upperExp);
        }
        if (expressions.size() == 2) {
            return Expressions.and((Expression)((Expression)expressions.get(0)), (Expression)((Expression)expressions.get(1)));
        }
        return (Expression)expressions.get(0);
    }
}

