/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.iceberg.filter;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.druid.iceberg.filter.IcebergAndFilter;
import org.apache.druid.iceberg.filter.IcebergFilter;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.False;

public class IcebergOrFilter
implements IcebergFilter {
    private final List<IcebergFilter> filters;
    private static final Logger log = new Logger(IcebergAndFilter.class);

    @JsonCreator
    public IcebergOrFilter(@JsonProperty(value="filters") List<IcebergFilter> filters) {
        Preconditions.checkArgument((filters != null && filters.size() > 0 ? 1 : 0) != 0, (Object)"filter requires atleast one field");
        this.filters = filters;
    }

    @JsonProperty
    public List<IcebergFilter> getFilters() {
        return this.filters;
    }

    @Override
    public TableScan filter(TableScan tableScan) {
        return (TableScan)tableScan.filter(this.getFilterExpression());
    }

    @Override
    public Expression getFilterExpression() {
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        LinkedHashSet<IcebergFilter> flatFilters = IcebergOrFilter.flattenOrChildren(this.filters);
        for (IcebergFilter filter : flatFilters) {
            expressions.add(filter.getFilterExpression());
        }
        False finalExpr = Expressions.alwaysFalse();
        for (Expression expr : expressions) {
            finalExpr = Expressions.or((Expression)finalExpr, (Expression)expr);
        }
        return finalExpr;
    }

    private static LinkedHashSet<IcebergFilter> flattenOrChildren(Collection<IcebergFilter> filters) {
        LinkedHashSet<IcebergFilter> retVal = new LinkedHashSet<IcebergFilter>();
        for (IcebergFilter child : filters) {
            if (child instanceof IcebergOrFilter) {
                retVal.addAll(IcebergOrFilter.flattenOrChildren(((IcebergOrFilter)child).getFilters()));
                continue;
            }
            retVal.add(child);
        }
        return retVal;
    }
}

