/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.iceberg.filter;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import org.apache.druid.iceberg.filter.IcebergFilter;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;

public class IcebergNotFilter
implements IcebergFilter {
    private final IcebergFilter filter;

    @JsonCreator
    public IcebergNotFilter(@JsonProperty(value="filter") IcebergFilter filter) {
        Preconditions.checkNotNull((Object)filter, (Object)"You must specify an iceberg filter");
        this.filter = filter;
    }

    @Override
    public TableScan filter(TableScan tableScan) {
        return (TableScan)tableScan.filter(this.getFilterExpression());
    }

    @Override
    public Expression getFilterExpression() {
        return Expressions.not((Expression)this.filter.getFilterExpression());
    }

    @JsonProperty
    public IcebergFilter getFilter() {
        return this.filter;
    }
}

