/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.iceberg.filter;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.apache.druid.iceberg.filter.IcebergFilter;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.False;
import org.apache.iceberg.expressions.Literal;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.joda.time.Interval;

public class IcebergIntervalFilter
implements IcebergFilter {
    @JsonProperty
    private final String filterColumn;
    @JsonProperty
    private final List<Interval> intervals;

    @JsonCreator
    public IcebergIntervalFilter(@JsonProperty(value="filterColumn") String filterColumn, @JsonProperty(value="intervals") List<Interval> intervals) {
        Preconditions.checkNotNull((Object)filterColumn, (Object)"You must specify a filter column on the interval filter");
        Preconditions.checkArgument((intervals != null && intervals.size() > 0 ? 1 : 0) != 0, (Object)"You must specify intervals on the interval filter");
        this.filterColumn = filterColumn;
        this.intervals = intervals;
    }

    @Override
    public TableScan filter(TableScan tableScan) {
        return (TableScan)tableScan.filter(this.getFilterExpression());
    }

    @Override
    public Expression getFilterExpression() {
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        for (Interval filterInterval : this.intervals) {
            Long dateStart = (long)((Long)Literal.of((CharSequence)filterInterval.getStart().toString()).to((Type)Types.TimestampType.withZone()).value());
            Long dateEnd = (long)((Long)Literal.of((CharSequence)filterInterval.getEnd().toString()).to((Type)Types.TimestampType.withZone()).value());
            expressions.add(Expressions.and((Expression)Expressions.greaterThanOrEqual((String)this.filterColumn, (Object)dateStart), (Expression)Expressions.lessThan((String)this.filterColumn, (Object)dateEnd)));
        }
        False finalExpr = Expressions.alwaysFalse();
        for (Expression filterExpr : expressions) {
            finalExpr = Expressions.or((Expression)finalExpr, (Expression)filterExpr);
        }
        return finalExpr;
    }
}

