/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.iceberg.filter;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import org.apache.druid.iceberg.filter.IcebergFilter;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;

public class IcebergEqualsFilter
implements IcebergFilter {
    @JsonProperty
    private final String filterColumn;
    @JsonProperty
    private final String filterValue;

    @JsonCreator
    public IcebergEqualsFilter(@JsonProperty(value="filterColumn") String filterColumn, @JsonProperty(value="filterValue") String filterValue) {
        Preconditions.checkNotNull((Object)filterColumn, (Object)"You must specify a filter column on the equals filter");
        Preconditions.checkNotNull((Object)filterValue, (Object)"You must specify a filter value on the equals filter");
        this.filterColumn = filterColumn;
        this.filterValue = filterValue;
    }

    @Override
    public TableScan filter(TableScan tableScan) {
        return (TableScan)tableScan.filter(this.getFilterExpression());
    }

    @Override
    public Expression getFilterExpression() {
        return Expressions.equal((String)this.filterColumn, (Object)this.filterValue);
    }
}

