/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.iceberg.common;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.inject.Binder;
import java.util.Collections;
import java.util.List;
import org.apache.druid.error.DruidException;
import org.apache.druid.iceberg.guice.HiveConf;
import org.apache.druid.iceberg.input.GlueIcebergCatalog;
import org.apache.druid.iceberg.input.HiveIcebergCatalog;
import org.apache.druid.iceberg.input.IcebergInputSource;
import org.apache.druid.iceberg.input.LocalCatalog;
import org.apache.druid.iceberg.input.RestIcebergCatalog;
import org.apache.druid.initialization.DruidModule;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;

public class IcebergDruidModule
implements DruidModule {
    public List<? extends Module> getJacksonModules() {
        return Collections.singletonList(new SimpleModule("IcebergDruidModule").registerSubtypes(new NamedType[]{new NamedType(HiveIcebergCatalog.class, "hive"), new NamedType(LocalCatalog.class, "local"), new NamedType(RestIcebergCatalog.class, "rest"), new NamedType(IcebergInputSource.class, "iceberg"), new NamedType(GlueIcebergCatalog.class, "glue")}));
    }

    public void configure(Binder binder) {
        Configuration conf = new Configuration();
        conf.setClassLoader(this.getClass().getClassLoader());
        ClassLoader currCtxCl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            FileSystem.get((Configuration)conf);
        }
        catch (Exception ex) {
            throw DruidException.forPersona((DruidException.Persona)DruidException.Persona.DEVELOPER).ofCategory(DruidException.Category.UNCATEGORIZED).build((Throwable)ex, "Problem during fileSystem class level initialization", new Object[0]);
        }
        finally {
            Thread.currentThread().setContextClassLoader(currCtxCl);
        }
        binder.bind(Configuration.class).annotatedWith(HiveConf.class).toInstance((Object)conf);
    }
}

