/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.exact.count.bitmap64.sql;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlSingleOperandTypeChecker;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.aggregation.exact.count.bitmap64.Bitmap64ExactCountBuildAggregatorFactory;
import org.apache.druid.query.aggregation.exact.count.bitmap64.Bitmap64ExactCountMergeAggregatorFactory;
import org.apache.druid.query.aggregation.post.FinalizingFieldAccessPostAggregator;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.column.TypeDescriptor;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.sql.calcite.aggregation.Aggregation;
import org.apache.druid.sql.calcite.aggregation.SqlAggregator;
import org.apache.druid.sql.calcite.aggregation.builtin.SimpleSqlAggregator;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.expression.Expressions;
import org.apache.druid.sql.calcite.expression.OperatorConversions;
import org.apache.druid.sql.calcite.planner.Calcites;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.rel.VirtualColumnRegistry;
import org.apache.druid.sql.calcite.table.RowSignatures;

public class Bitmap64ExactCountSqlAggregator
implements SqlAggregator {
    private static final String NAME = "BITMAP64_EXACT_COUNT";
    private static final SqlAggFunction FUNCTION_INSTANCE = (SqlAggFunction)OperatorConversions.aggregatorBuilder((String)"BITMAP64_EXACT_COUNT").operandTypeChecker((SqlOperandTypeChecker)OperandTypes.or((SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.NUMERIC, RowSignatures.complexTypeChecker((ColumnType)Bitmap64ExactCountMergeAggregatorFactory.TYPE), RowSignatures.complexTypeChecker((ColumnType)Bitmap64ExactCountBuildAggregatorFactory.TYPE)})).returnTypeNonNull(SqlTypeName.BIGINT).functionCategory(SqlFunctionCategory.NUMERIC).build();

    public SqlAggFunction calciteFunction() {
        return FUNCTION_INSTANCE;
    }

    @Nullable
    public Aggregation toDruidAggregation(PlannerContext plannerContext, RowSignature rowSignature, VirtualColumnRegistry virtualColumnRegistry, RexBuilder rexBuilder, String name, AggregateCall aggregateCall, Project project, List<Aggregation> existingAggregations, boolean finalizeAggregations) {
        Bitmap64ExactCountMergeAggregatorFactory aggregatorFactory;
        String aggregatorName;
        RexNode columnRexNode = Expressions.fromFieldAccess((RelDataTypeFactory)rexBuilder.getTypeFactory(), (RowSignature)rowSignature, (Project)project, (int)((Integer)aggregateCall.getArgList().get(0)));
        DruidExpression columnArg = Expressions.toDruidExpression((PlannerContext)plannerContext, (RowSignature)rowSignature, (RexNode)columnRexNode);
        if (columnArg == null) {
            return null;
        }
        String string = aggregatorName = finalizeAggregations ? Calcites.makePrefixedName((String)name, (String)"a") : name;
        if (this.isBitmap64ComplexType(columnArg, rowSignature)) {
            aggregatorFactory = new Bitmap64ExactCountMergeAggregatorFactory(aggregatorName, columnArg.getDirectColumn());
        } else {
            this.rejectImplicitCastsToNumericType(columnRexNode, name);
            aggregatorFactory = this.createBuildAggregatorFactory(columnRexNode, columnArg, virtualColumnRegistry, aggregatorName);
        }
        return this.toAggregation(name, finalizeAggregations, aggregatorFactory);
    }

    private boolean isBitmap64ComplexType(DruidExpression columnArg, RowSignature rowSignature) {
        return columnArg.isDirectColumnAccess() && rowSignature.getColumnType(columnArg.getDirectColumn()).map(type -> type.is((TypeDescriptor)ValueType.COMPLEX)).orElse(false) != false;
    }

    private void rejectImplicitCastsToNumericType(RexNode columnRexNode, String columnName) {
        RelDataType operandType;
        ColumnType operandDruidType;
        if (columnRexNode.isA(SqlKind.CAST) && ((operandDruidType = Calcites.getColumnTypeForRelDataType((RelDataType)(operandType = ((RexNode)((RexCall)columnRexNode).operands.get(0)).getType()))) == null || !operandDruidType.isNumeric())) {
            throw SimpleSqlAggregator.badTypeException((String)columnName, (String)NAME, (ColumnType)ColumnType.STRING);
        }
    }

    private AggregatorFactory createBuildAggregatorFactory(RexNode columnRexNode, DruidExpression columnArg, VirtualColumnRegistry virtualColumnRegistry, String aggregatorName) {
        DimensionSpec dimensionSpec;
        RelDataType dataType = columnRexNode.getType();
        ColumnType inputType = Calcites.getColumnTypeForRelDataType((RelDataType)dataType);
        if (inputType == null) {
            throw new ISE("Cannot translate sqlTypeName[%s] to Druid type for field[%s]", new Object[]{dataType.getSqlTypeName(), aggregatorName});
        }
        if (columnArg.isDirectColumnAccess()) {
            dimensionSpec = columnArg.getSimpleExtraction().toDimensionSpec(null, inputType);
        } else {
            String virtualColumnName = virtualColumnRegistry.getOrCreateVirtualColumnForExpression(columnArg, dataType);
            dimensionSpec = new DefaultDimensionSpec(virtualColumnName, null, inputType);
        }
        return new Bitmap64ExactCountBuildAggregatorFactory(aggregatorName, dimensionSpec.getDimension());
    }

    private Aggregation toAggregation(String name, boolean finalizeAggregations, AggregatorFactory aggregatorFactory) {
        return Aggregation.create(Collections.singletonList(aggregatorFactory), (PostAggregator)(finalizeAggregations ? new FinalizingFieldAccessPostAggregator(name, aggregatorFactory.getName()) : null));
    }
}

