/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.exact.count.bitmap64;

import com.fasterxml.jackson.databind.util.ByteBufferBackedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.druid.query.aggregation.exact.count.bitmap64.Bitmap64;
import org.apache.druid.query.aggregation.exact.count.bitmap64.Bitmap64ExactCountAggregatorFactory;
import org.apache.druid.query.aggregation.exact.count.bitmap64.RoaringBitmap64Counter;
import org.apache.druid.segment.data.ObjectStrategy;

public class Bitmap64ExactCountObjectStrategy
implements ObjectStrategy<Bitmap64> {
    static final Bitmap64ExactCountObjectStrategy STRATEGY = new Bitmap64ExactCountObjectStrategy();

    public Class<? extends Bitmap64> getClazz() {
        return RoaringBitmap64Counter.class;
    }

    @Nullable
    public Bitmap64 fromByteBuffer(ByteBuffer buffer, int numBytes) {
        DataInputStream dataInputStream;
        ByteBuffer readOnlyBuf = buffer.asReadOnlyBuffer();
        if (readOnlyBuf.remaining() < numBytes) {
            throw new BufferUnderflowException();
        }
        if (readOnlyBuf.hasArray()) {
            dataInputStream = new DataInputStream(new ByteArrayInputStream(readOnlyBuf.array(), readOnlyBuf.arrayOffset() + readOnlyBuf.position(), numBytes));
        } else {
            ByteBuffer slice = readOnlyBuf.slice();
            slice.limit(numBytes);
            dataInputStream = new DataInputStream((InputStream)new ByteBufferBackedInputStream(slice));
        }
        return RoaringBitmap64Counter.fromDataInput(dataInputStream);
    }

    @Nullable
    public byte[] toBytes(@Nullable Bitmap64 val) {
        if (val == null) {
            return new byte[0];
        }
        return val.toByteBuffer().array();
    }

    public int compare(Bitmap64 o1, Bitmap64 o2) {
        return Bitmap64ExactCountAggregatorFactory.COMPARATOR.compare(o1, o2);
    }
}

