/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.delta.input;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.delta.kernel.data.ArrayValue;
import io.delta.kernel.data.MapValue;
import io.delta.kernel.data.Row;
import io.delta.kernel.defaults.internal.data.DefaultJsonRow;
import io.delta.kernel.engine.Engine;
import io.delta.kernel.internal.util.VectorUtils;
import io.delta.kernel.types.ArrayType;
import io.delta.kernel.types.BooleanType;
import io.delta.kernel.types.ByteType;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.DateType;
import io.delta.kernel.types.DecimalType;
import io.delta.kernel.types.DoubleType;
import io.delta.kernel.types.FloatType;
import io.delta.kernel.types.IntegerType;
import io.delta.kernel.types.LongType;
import io.delta.kernel.types.MapType;
import io.delta.kernel.types.ShortType;
import io.delta.kernel.types.StringType;
import io.delta.kernel.types.StructField;
import io.delta.kernel.types.StructType;
import io.delta.kernel.types.TimestampType;
import java.util.HashMap;
import java.util.Map;
import org.apache.druid.delta.input.DeltaTimeUtils;
import org.apache.druid.error.InvalidInput;
import org.apache.druid.jackson.DefaultObjectMapper;

public class RowSerde {
    private static final ObjectMapper OBJECT_MAPPER = new DefaultObjectMapper();

    private RowSerde() {
    }

    public static String serializeRowToJson(Row row) {
        Map<String, Object> rowObject = RowSerde.convertRowToJsonObject(row);
        try {
            HashMap<String, Object> rowWithSchema = new HashMap<String, Object>();
            rowWithSchema.put("schema", row.getSchema().toJson());
            rowWithSchema.put("row", rowObject);
            return OBJECT_MAPPER.writeValueAsString(rowWithSchema);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static Row deserializeRowFromJson(Engine engine, String jsonRowWithSchema) {
        try {
            JsonNode jsonNode = OBJECT_MAPPER.readTree(jsonRowWithSchema);
            JsonNode schemaNode = jsonNode.get("schema");
            StructType schema = engine.getJsonHandler().deserializeStructType(schemaNode.asText());
            return RowSerde.parseRowFromJsonWithSchema((ObjectNode)jsonNode.get("row"), schema);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<String, Object> convertRowToJsonObject(Row row) {
        StructType rowType = row.getSchema();
        HashMap<String, Object> rowObject = new HashMap<String, Object>();
        for (int fieldId = 0; fieldId < rowType.length(); ++fieldId) {
            Map<String, Object> value;
            StructField field = rowType.at(fieldId);
            DataType fieldType = field.getDataType();
            String name = field.getName();
            if (row.isNullAt(fieldId)) {
                rowObject.put(name, null);
                continue;
            }
            if (fieldType instanceof BooleanType) {
                value = row.getBoolean(fieldId);
            } else if (fieldType instanceof ByteType) {
                value = row.getByte(fieldId);
            } else if (fieldType instanceof ShortType) {
                value = row.getShort(fieldId);
            } else if (fieldType instanceof IntegerType) {
                value = row.getInt(fieldId);
            } else if (fieldType instanceof LongType) {
                value = row.getLong(fieldId);
            } else if (fieldType instanceof FloatType) {
                value = Float.valueOf(row.getFloat(fieldId));
            } else if (fieldType instanceof DoubleType) {
                value = row.getDouble(fieldId);
            } else if (fieldType instanceof DecimalType) {
                value = row.getDecimal(fieldId);
            } else if (fieldType instanceof DateType) {
                value = DeltaTimeUtils.getSecondsFromDate(row.getInt(fieldId));
            } else if (fieldType instanceof TimestampType) {
                value = DeltaTimeUtils.getMillisFromTimestamp(row.getLong(fieldId));
            } else if (fieldType instanceof StringType) {
                value = row.getString(fieldId);
            } else if (fieldType instanceof ArrayType) {
                value = VectorUtils.toJavaList((ArrayValue)row.getArray(fieldId));
            } else if (fieldType instanceof MapType) {
                value = VectorUtils.toJavaMap((MapValue)row.getMap(fieldId));
            } else if (fieldType instanceof StructType) {
                Row subRow = row.getStruct(fieldId);
                value = RowSerde.convertRowToJsonObject(subRow);
            } else {
                throw InvalidInput.exception((String)"Unsupported fieldType[%s] for fieldName[%s]", (Object[])new Object[]{fieldType, name});
            }
            rowObject.put(name, value);
        }
        return rowObject;
    }

    private static Row parseRowFromJsonWithSchema(ObjectNode rowJsonNode, StructType rowType) {
        return new DefaultJsonRow(rowJsonNode, rowType);
    }
}

